package binders

// |@@| C

import (
	"context"
	"gardening/src/dat/maes"
	"gardening/src/lib/binder"
	"github.com/gin-gonic/gin"
)

type CreatePlantAppBinder struct {
	Binder *binder.Binder
}

func (this *CreatePlantAppBinder) Bind(ctx context.Context, in *maes.CreatePlantMaeIn, c *gin.Context) error {
	this.bindRequest(ctx, in, c)
	return nil
}
func (this *CreatePlantAppBinder) bindRequestForm(ctx context.Context, in *maes.CreatePlantMaeIn, c *gin.Context) error {
	s := &in.Request.Form
	s.Data = this.Binder.PostFormJsonField("form[data]", c, &in.Context)
	s.Description = this.Binder.PostFormStringField("form[description]", c, &in.Context)
	s.Exposition = this.Binder.PostFormStringField("form[exposition]", c, &in.Context)
	s.Harvested = this.Binder.PostFormDecimalField("form[harvested]", c, &in.Context)
	s.Name = this.Binder.PostFormStringField("form[name]", c, &in.Context)
	s.Perennial = this.Binder.PostFormBooleanField("form[perennial]", c, &in.Context)
	s.Reference = this.Binder.PostFormStringField("form[reference]", c, &in.Context)
	s.Size = this.Binder.PostFormIntegerField("form[size]", c, &in.Context)
	return nil
}
func (this *CreatePlantAppBinder) bindRequest(ctx context.Context, in *maes.CreatePlantMaeIn, c *gin.Context) error {
	this.bindRequestForm(ctx, in, c)
	return nil
}
