package binders

// |@@| C

import (
	"context"
	"gardening/src/dat/maes"
	"gardening/src/lib/binder"
	"github.com/gin-gonic/gin"
)

type CreatePlantTaskAppBinder struct {
	Binder *binder.Binder
}

func (this *CreatePlantTaskAppBinder) Bind(ctx context.Context, in *maes.CreatePlantTaskMaeIn, c *gin.Context) error {
	this.bindRequest(ctx, in, c)
	return nil
}
func (this *CreatePlantTaskAppBinder) bindRequestForm(ctx context.Context, in *maes.CreatePlantTaskMaeIn, c *gin.Context) error {
	s := &in.Request.Form
	s.Description = this.Binder.PostFormStringField("form[description]", c, &in.Context)
	s.Name = this.Binder.PostFormStringField("form[name]", c, &in.Context)
	s.StartDate = this.Binder.PostFormTimeField("form[start_date]", c, &in.Context)
	s.PlantId = this.Binder.PostFormStringField("form[plant_id]", c, &in.Context)
	s.SendEmail = this.Binder.PostFormBooleanField("form[send_email]", c, &in.Context)
	return nil
}
func (this *CreatePlantTaskAppBinder) bindRequest(ctx context.Context, in *maes.CreatePlantTaskMaeIn, c *gin.Context) error {
	this.bindRequestForm(ctx, in, c)
	return nil
}
