package binders

// |@@| C

import (
	"context"
	"gardening/src/dat/maes"
	"gardening/src/lib/binder"
	"github.com/gin-gonic/gin"
)

type CreatePlantationAppBinder struct {
	Binder *binder.Binder
}

func (this *CreatePlantationAppBinder) Bind(ctx context.Context, in *maes.CreatePlantationMaeIn, c *gin.Context) error {
	this.bindRequest(ctx, in, c)
	return nil
}
func (this *CreatePlantationAppBinder) bindRequestForm(ctx context.Context, in *maes.CreatePlantationMaeIn, c *gin.Context) error {
	s := &in.Request.Form
	s.Name = this.Binder.PostFormStringField("form[name]", c, &in.Context)
	s.PlantedAt = this.Binder.PostFormTimeField("form[planted_at]", c, &in.Context)
	s.PlantId = this.Binder.PostFormStringField("form[plant_id]", c, &in.Context)
	s.GardenId = this.Binder.PostFormStringField("form[garden_id]", c, &in.Context)
	return nil
}
func (this *CreatePlantationAppBinder) bindRequest(ctx context.Context, in *maes.CreatePlantationMaeIn, c *gin.Context) error {
	this.bindRequestForm(ctx, in, c)
	return nil
}
