package binders

// |@@| C

import (
	"context"
	"gardening/src/dat/maes"
	"gardening/src/lib/binder"
	"github.com/gin-gonic/gin"
)

type CreateUserAppBinder struct {
	Binder *binder.Binder
}

func (this *CreateUserAppBinder) Bind(ctx context.Context, in *maes.CreateUserMaeIn, c *gin.Context) error {
	this.bindRequest(ctx, in, c)
	return nil
}
func (this *CreateUserAppBinder) bindRequestForm(ctx context.Context, in *maes.CreateUserMaeIn, c *gin.Context) error {
	s := &in.Request.Form
	s.Name = this.Binder.PostFormStringField("form[name]", c, &in.Context)
	return nil
}
func (this *CreateUserAppBinder) bindRequest(ctx context.Context, in *maes.CreateUserMaeIn, c *gin.Context) error {
	this.bindRequestForm(ctx, in, c)
	return nil
}
