package binders

// |@@| C

import (
	"context"
	"gardening/src/dat/maes"
	"gardening/src/lib/binder"
	"github.com/gin-gonic/gin"
)

type EditGardenAppBinder struct {
	Binder *binder.Binder
}

func (this *EditGardenAppBinder) Bind(ctx context.Context, in *maes.EditGardenMaeIn, c *gin.Context) error {
	this.bindRequest(ctx, in, c)
	return nil
}
func (this *EditGardenAppBinder) bindRequestForm(ctx context.Context, in *maes.EditGardenMaeIn, c *gin.Context) error {
	s := &in.Request.Form
	s.Id = this.Binder.QueryStringField("form[id]", c, &in.Context)
	s.Name = this.Binder.QueryStringField("form[name]", c, &in.Context)
	s.Picture = this.Binder.QueryStringField("form[picture]", c, &in.Context)
	return nil
}
func (this *EditGardenAppBinder) bindRequest(ctx context.Context, in *maes.EditGardenMaeIn, c *gin.Context) error {
	this.bindRequestForm(ctx, in, c)
	return nil
}
