package binders

// |@@| C

import (
	"context"
	"gardening/src/dat/maes"
	"gardening/src/lib/binder"
	"github.com/gin-gonic/gin"
)

type EditGardenTaskAppBinder struct {
	Binder *binder.Binder
}

func (this *EditGardenTaskAppBinder) Bind(ctx context.Context, in *maes.EditGardenTaskMaeIn, c *gin.Context) error {
	this.bindRequest(ctx, in, c)
	return nil
}
func (this *EditGardenTaskAppBinder) bindRequestForm(ctx context.Context, in *maes.EditGardenTaskMaeIn, c *gin.Context) error {
	s := &in.Request.Form
	s.Id = this.Binder.QueryStringField("form[id]", c, &in.Context)
	s.Description = this.Binder.QueryStringField("form[description]", c, &in.Context)
	s.Name = this.Binder.QueryStringField("form[name]", c, &in.Context)
	s.StartDate = this.Binder.QueryTimeField("form[start_date]", c, &in.Context)
	s.GardenId = this.Binder.QueryStringField("form[garden_id]", c, &in.Context)
	s.PlantationId = this.Binder.QueryStringField("form[plantation_id]", c, &in.Context)
	return nil
}
func (this *EditGardenTaskAppBinder) bindRequest(ctx context.Context, in *maes.EditGardenTaskMaeIn, c *gin.Context) error {
	this.bindRequestForm(ctx, in, c)
	return nil
}
