package binders

// |@@| C

import (
	"context"
	"gardening/src/dat/maes"
	"gardening/src/lib/binder"
	"github.com/gin-gonic/gin"
)

type EditPlantTaskAppBinder struct {
	Binder *binder.Binder
}

func (this *EditPlantTaskAppBinder) Bind(ctx context.Context, in *maes.EditPlantTaskMaeIn, c *gin.Context) error {
	this.bindRequest(ctx, in, c)
	return nil
}
func (this *EditPlantTaskAppBinder) bindRequestForm(ctx context.Context, in *maes.EditPlantTaskMaeIn, c *gin.Context) error {
	s := &in.Request.Form
	s.Id = this.Binder.QueryStringField("form[id]", c, &in.Context)
	s.Description = this.Binder.QueryStringField("form[description]", c, &in.Context)
	s.Name = this.Binder.QueryStringField("form[name]", c, &in.Context)
	s.StartDate = this.Binder.QueryTimeField("form[start_date]", c, &in.Context)
	s.PlantId = this.Binder.QueryStringField("form[plant_id]", c, &in.Context)
	return nil
}
func (this *EditPlantTaskAppBinder) bindRequest(ctx context.Context, in *maes.EditPlantTaskMaeIn, c *gin.Context) error {
	this.bindRequestForm(ctx, in, c)
	return nil
}
