package binders

// |@@| C

import (
	"context"
	"gardening/src/dat/maes"
	"gardening/src/lib/binder"
	"github.com/gin-gonic/gin"
)

type EditUserAppBinder struct {
	Binder *binder.Binder
}

func (this *EditUserAppBinder) Bind(ctx context.Context, in *maes.EditUserMaeIn, c *gin.Context) error {
	this.bindRequest(ctx, in, c)
	return nil
}
func (this *EditUserAppBinder) bindRequestForm(ctx context.Context, in *maes.EditUserMaeIn, c *gin.Context) error {
	s := &in.Request.Form
	s.Id = this.Binder.QueryStringField("form[id]", c, &in.Context)
	s.Name = this.Binder.QueryStringField("form[name]", c, &in.Context)
	return nil
}
func (this *EditUserAppBinder) bindRequest(ctx context.Context, in *maes.EditUserMaeIn, c *gin.Context) error {
	this.bindRequestForm(ctx, in, c)
	return nil
}
