package binders

// |@@| C

import (
	"context"
	"gardening/src/dat/maes"
	"gardening/src/lib/binder"
	"github.com/gin-gonic/gin"
)

type ListGardenTasksAppBinder struct {
	Binder *binder.Binder
}

func (this *ListGardenTasksAppBinder) Bind(ctx context.Context, in *maes.ListGardenTasksMaeIn, c *gin.Context) error {
	this.bindRequest(ctx, in, c)
	return nil
}
func (this *ListGardenTasksAppBinder) bindRequest(ctx context.Context, in *maes.ListGardenTasksMaeIn, c *gin.Context) error {
	s := &in.Request
	s.Page = this.Binder.QueryIntegerField("page", c, &in.Context)
	s.Filters = this.Binder.ExtractRawFiltersFromUrl(c)
	s.Columns = this.Binder.ExtractColumnsFromUrl(c)
	return nil
}
