package binders

// |@@| C

import (
	"context"
	"gardening/src/dat/maes"
	"gardening/src/lib/binder"
	"github.com/gin-gonic/gin"
)

type NewGardenAppBinder struct {
	Binder *binder.Binder
}

func (this *NewGardenAppBinder) Bind(ctx context.Context, in *maes.NewGardenMaeIn, c *gin.Context) error {
	this.bindRequest(ctx, in, c)
	return nil
}
func (this *NewGardenAppBinder) bindRequestForm(ctx context.Context, in *maes.NewGardenMaeIn, c *gin.Context) error {
	s := &in.Request.Form
	s.Name = this.Binder.QueryStringField("form[name]", c, &in.Context)
	s.Picture = this.Binder.QueryStringField("form[picture]", c, &in.Context)
	return nil
}
func (this *NewGardenAppBinder) bindRequest(ctx context.Context, in *maes.NewGardenMaeIn, c *gin.Context) error {
	this.bindRequestForm(ctx, in, c)
	return nil
}
