package binders

// |@@| C

import (
	"context"
	"gardening/src/dat/maes"
	"gardening/src/lib/binder"
	"github.com/gin-gonic/gin"
)

type NewGardenTaskAppBinder struct {
	Binder *binder.Binder
}

func (this *NewGardenTaskAppBinder) Bind(ctx context.Context, in *maes.NewGardenTaskMaeIn, c *gin.Context) error {
	this.bindRequest(ctx, in, c)
	return nil
}
func (this *NewGardenTaskAppBinder) bindRequestForm(ctx context.Context, in *maes.NewGardenTaskMaeIn, c *gin.Context) error {
	s := &in.Request.Form
	s.Description = this.Binder.QueryStringField("form[description]", c, &in.Context)
	s.Name = this.Binder.QueryStringField("form[name]", c, &in.Context)
	s.StartDate = this.Binder.QueryTimeField("form[start_date]", c, &in.Context)
	s.GardenId = this.Binder.QueryStringField("form[garden_id]", c, &in.Context)
	s.PlantationId = this.Binder.QueryStringField("form[plantation_id]", c, &in.Context)
	return nil
}
func (this *NewGardenTaskAppBinder) bindRequest(ctx context.Context, in *maes.NewGardenTaskMaeIn, c *gin.Context) error {
	this.bindRequestForm(ctx, in, c)
	return nil
}
