package binders

// |@@| C

import (
	"context"
	"gardening/src/dat/maes"
	"gardening/src/lib/binder"
	"github.com/gin-gonic/gin"
)

type NewPlantAppBinder struct {
	Binder *binder.Binder
}

func (this *NewPlantAppBinder) Bind(ctx context.Context, in *maes.NewPlantMaeIn, c *gin.Context) error {
	this.bindRequest(ctx, in, c)
	return nil
}
func (this *NewPlantAppBinder) bindRequestForm(ctx context.Context, in *maes.NewPlantMaeIn, c *gin.Context) error {
	s := &in.Request.Form
	s.Data = this.Binder.QueryJsonField("form[data]", c, &in.Context)
	s.Description = this.Binder.QueryStringField("form[description]", c, &in.Context)
	s.Exposition = this.Binder.QueryStringField("form[exposition]", c, &in.Context)
	s.Harvested = this.Binder.QueryDecimalField("form[harvested]", c, &in.Context)
	s.Name = this.Binder.QueryStringField("form[name]", c, &in.Context)
	s.Perennial = this.Binder.QueryBooleanField("form[perennial]", c, &in.Context)
	s.Reference = this.Binder.QueryStringField("form[reference]", c, &in.Context)
	s.Size = this.Binder.QueryIntegerField("form[size]", c, &in.Context)
	return nil
}
func (this *NewPlantAppBinder) bindRequest(ctx context.Context, in *maes.NewPlantMaeIn, c *gin.Context) error {
	this.bindRequestForm(ctx, in, c)
	return nil
}
