package binders

// |@@| C

import (
	"context"
	"gardening/src/dat/maes"
	"gardening/src/lib/binder"
	"github.com/gin-gonic/gin"
)

type NewPlantTaskAppBinder struct {
	Binder *binder.Binder
}

func (this *NewPlantTaskAppBinder) Bind(ctx context.Context, in *maes.NewPlantTaskMaeIn, c *gin.Context) error {
	this.bindRequest(ctx, in, c)
	return nil
}
func (this *NewPlantTaskAppBinder) bindRequestForm(ctx context.Context, in *maes.NewPlantTaskMaeIn, c *gin.Context) error {
	s := &in.Request.Form
	s.Description = this.Binder.QueryStringField("form[description]", c, &in.Context)
	s.Name = this.Binder.QueryStringField("form[name]", c, &in.Context)
	s.StartDate = this.Binder.QueryTimeField("form[start_date]", c, &in.Context)
	s.PlantId = this.Binder.QueryStringField("form[plant_id]", c, &in.Context)
	s.SendEmail = this.Binder.QueryBooleanField("form[send_email]", c, &in.Context)
	return nil
}
func (this *NewPlantTaskAppBinder) bindRequest(ctx context.Context, in *maes.NewPlantTaskMaeIn, c *gin.Context) error {
	this.bindRequestForm(ctx, in, c)
	return nil
}
