package binders

// |@@| C

import (
	"context"
	"gardening/src/dat/maes"
	"gardening/src/lib/binder"
	"github.com/gin-gonic/gin"
)

type NewPlantationAppBinder struct {
	Binder *binder.Binder
}

func (this *NewPlantationAppBinder) Bind(ctx context.Context, in *maes.NewPlantationMaeIn, c *gin.Context) error {
	this.bindRequest(ctx, in, c)
	return nil
}
func (this *NewPlantationAppBinder) bindRequestForm(ctx context.Context, in *maes.NewPlantationMaeIn, c *gin.Context) error {
	s := &in.Request.Form
	s.Name = this.Binder.QueryStringField("form[name]", c, &in.Context)
	s.PlantedAt = this.Binder.QueryTimeField("form[planted_at]", c, &in.Context)
	s.PlantId = this.Binder.QueryStringField("form[plant_id]", c, &in.Context)
	s.GardenId = this.Binder.QueryStringField("form[garden_id]", c, &in.Context)
	return nil
}
func (this *NewPlantationAppBinder) bindRequest(ctx context.Context, in *maes.NewPlantationMaeIn, c *gin.Context) error {
	this.bindRequestForm(ctx, in, c)
	return nil
}
