package binders

// |@@| C

import (
	"context"
	"gardening/src/dat/maes"
	"gardening/src/lib/binder"
	"github.com/gin-gonic/gin"
)

type NewSeedProgramAppBinder struct {
	Binder *binder.Binder
}

func (this *NewSeedProgramAppBinder) Bind(ctx context.Context, in *maes.NewSeedProgramMaeIn, c *gin.Context) error {
	this.bindRequest(ctx, in, c)
	return nil
}
func (this *NewSeedProgramAppBinder) bindRequestForm(ctx context.Context, in *maes.NewSeedProgramMaeIn, c *gin.Context) error {
	s := &in.Request.Form
	s.Contact = this.Binder.QueryStringField("form[contact]", c, &in.Context)
	s.Description = this.Binder.QueryStringField("form[description]", c, &in.Context)
	s.Name = this.Binder.QueryStringField("form[name]", c, &in.Context)
	s.PlantId = this.Binder.QueryStringField("form[plant_id]", c, &in.Context)
	return nil
}
func (this *NewSeedProgramAppBinder) bindRequest(ctx context.Context, in *maes.NewSeedProgramMaeIn, c *gin.Context) error {
	this.bindRequestForm(ctx, in, c)
	return nil
}
