package binders

// |@@| C

import (
	"context"
	"gardening/src/dat/maes"
	"gardening/src/lib/binder"
	"github.com/gin-gonic/gin"
)

type NewUserAppBinder struct {
	Binder *binder.Binder
}

func (this *NewUserAppBinder) Bind(ctx context.Context, in *maes.NewUserMaeIn, c *gin.Context) error {
	this.bindRequest(ctx, in, c)
	return nil
}
func (this *NewUserAppBinder) bindRequestForm(ctx context.Context, in *maes.NewUserMaeIn, c *gin.Context) error {
	s := &in.Request.Form
	s.Name = this.Binder.QueryStringField("form[name]", c, &in.Context)
	return nil
}
func (this *NewUserAppBinder) bindRequest(ctx context.Context, in *maes.NewUserMaeIn, c *gin.Context) error {
	this.bindRequestForm(ctx, in, c)
	return nil
}
