package binders

// |@@| C

import (
	"context"
	"gardening/src/dat/forms"
	"gardening/src/dat/maes"
	"gardening/src/lib/binder"
	"github.com/gin-gonic/gin"
)

type SeeRenewOrdersAppBinder struct {
	Binder *binder.Binder
}

func (this *SeeRenewOrdersAppBinder) instance(ctx context.Context, in *maes.SeeRenewOrdersMaeIn, c *gin.Context) {
	in.Request.Form.Step1 = &forms.Step1PerformRenewOrdersForm{}
	in.Request.Form.Step2 = &forms.Step2PerformRenewOrdersForm{}
	in.Request.Form.Step3 = &forms.Step3PerformRenewOrdersForm{}
}
func (this *SeeRenewOrdersAppBinder) Bind(ctx context.Context, in *maes.SeeRenewOrdersMaeIn, c *gin.Context) error {
	this.instance(ctx, in, c)
	this.bindRequest(ctx, in, c)
	return nil
}
func (this *SeeRenewOrdersAppBinder) bindRequestFormStep1Crops(ctx context.Context, in *maes.SeeRenewOrdersMaeIn, c *gin.Context) error {
	st := in.Request.Form.Step1.Crops
	indexes := this.Binder.PostFormNestedField(c, "form[step1][crops][%s]")
	for _, index := range indexes {
		s := &forms.CropStep1PerformRenewOrdersForm{}
		st = append(st, s)
		s.PlantId = this.Binder.QueryStringField(this.Binder.DynamicKey("form[step1][crops][%s][plant_id]", index), c, &in.Context)
		s.Quantity = this.Binder.QueryIntegerField(this.Binder.DynamicKey("form[step1][crops][%s][quantity]", index), c, &in.Context)
	}
	in.Request.Form.Step1.Crops = st
	return nil
}
func (this *SeeRenewOrdersAppBinder) bindRequestFormStep1(ctx context.Context, in *maes.SeeRenewOrdersMaeIn, c *gin.Context) error {
	in.Request.Form.Step1 = &forms.Step1PerformRenewOrdersForm{}
	s := in.Request.Form.Step1
	s.Grouped = this.Binder.QueryBooleanField("form[step1][grouped]", c, &in.Context)
	this.bindRequestFormStep1Crops(ctx, in, c)
	return nil
}
func (this *SeeRenewOrdersAppBinder) bindRequestFormStep2(ctx context.Context, in *maes.SeeRenewOrdersMaeIn, c *gin.Context) error {
	in.Request.Form.Step2 = &forms.Step2PerformRenewOrdersForm{}
	s := in.Request.Form.Step2
	s.Address = this.Binder.QueryStringField("form[step2][address]", c, &in.Context)
	s.Country = this.Binder.QueryStringField("form[step2][country]", c, &in.Context)
	return nil
}
func (this *SeeRenewOrdersAppBinder) bindRequestFormStep3Emails(ctx context.Context, in *maes.SeeRenewOrdersMaeIn, c *gin.Context) error {
	st := in.Request.Form.Step3.Emails
	indexes := this.Binder.PostFormNestedField(c, "form[step3][emails][%s]")
	for _, index := range indexes {
		s := &forms.EmailStep3PerformRenewOrdersForm{}
		st = append(st, s)
		s.Email = this.Binder.QueryStringField(this.Binder.DynamicKey("form[step3][emails][%s][email]", index), c, &in.Context)
	}
	in.Request.Form.Step3.Emails = st
	return nil
}
func (this *SeeRenewOrdersAppBinder) bindRequestFormStep3(ctx context.Context, in *maes.SeeRenewOrdersMaeIn, c *gin.Context) error {
	this.bindRequestFormStep3Emails(ctx, in, c)
	return nil
}
func (this *SeeRenewOrdersAppBinder) bindRequestForm(ctx context.Context, in *maes.SeeRenewOrdersMaeIn, c *gin.Context) error {
	s := &in.Request.Form
	s.Confirm = this.Binder.QueryBooleanField("form[confirm]", c, &in.Context)
	s.Step = this.Binder.QueryStringField("form[step]", c, &in.Context)
	this.bindRequestFormStep1(ctx, in, c)
	this.bindRequestFormStep2(ctx, in, c)
	this.bindRequestFormStep3(ctx, in, c)
	return nil
}
func (this *SeeRenewOrdersAppBinder) bindRequest(ctx context.Context, in *maes.SeeRenewOrdersMaeIn, c *gin.Context) error {
	this.bindRequestForm(ctx, in, c)
	return nil
}
