package binders

// |@@| C

import (
	"context"
	"gardening/src/dat/maes"
	"gardening/src/lib/binder"
	"github.com/gin-gonic/gin"
)

type UpdateGardenTaskAppBinder struct {
	Binder *binder.Binder
}

func (this *UpdateGardenTaskAppBinder) Bind(ctx context.Context, in *maes.UpdateGardenTaskMaeIn, c *gin.Context) error {
	this.bindRequest(ctx, in, c)
	return nil
}
func (this *UpdateGardenTaskAppBinder) bindRequestForm(ctx context.Context, in *maes.UpdateGardenTaskMaeIn, c *gin.Context) error {
	s := &in.Request.Form
	s.Id = this.Binder.PostFormStringField("form[id]", c, &in.Context)
	s.Description = this.Binder.PostFormStringField("form[description]", c, &in.Context)
	s.Name = this.Binder.PostFormStringField("form[name]", c, &in.Context)
	s.StartDate = this.Binder.PostFormTimeField("form[start_date]", c, &in.Context)
	s.GardenId = this.Binder.PostFormStringField("form[garden_id]", c, &in.Context)
	s.PlantationId = this.Binder.PostFormStringField("form[plantation_id]", c, &in.Context)
	return nil
}
func (this *UpdateGardenTaskAppBinder) bindRequest(ctx context.Context, in *maes.UpdateGardenTaskMaeIn, c *gin.Context) error {
	this.bindRequestForm(ctx, in, c)
	return nil
}
