package binders

// |@@| C

import (
	"context"
	"gardening/src/dat/maes"
	"gardening/src/lib/binder"
	"github.com/gin-gonic/gin"
)

type UpdatePlantationAppBinder struct {
	Binder *binder.Binder
}

func (this *UpdatePlantationAppBinder) Bind(ctx context.Context, in *maes.UpdatePlantationMaeIn, c *gin.Context) error {
	this.bindRequest(ctx, in, c)
	return nil
}
func (this *UpdatePlantationAppBinder) bindRequestForm(ctx context.Context, in *maes.UpdatePlantationMaeIn, c *gin.Context) error {
	s := &in.Request.Form
	s.Id = this.Binder.PostFormStringField("form[id]", c, &in.Context)
	s.Name = this.Binder.PostFormStringField("form[name]", c, &in.Context)
	s.PlantedAt = this.Binder.PostFormTimeField("form[planted_at]", c, &in.Context)
	s.PlantId = this.Binder.PostFormStringField("form[plant_id]", c, &in.Context)
	s.GardenId = this.Binder.PostFormStringField("form[garden_id]", c, &in.Context)
	return nil
}
func (this *UpdatePlantationAppBinder) bindRequest(ctx context.Context, in *maes.UpdatePlantationMaeIn, c *gin.Context) error {
	this.bindRequestForm(ctx, in, c)
	return nil
}
