package binders

// |@@| C

import (
	"context"
	"gardening/src/dat/maes"
	"gardening/src/lib/binder"
	"github.com/gin-gonic/gin"
)

type UpdateSeedProgramAppBinder struct {
	Binder *binder.Binder
}

func (this *UpdateSeedProgramAppBinder) Bind(ctx context.Context, in *maes.UpdateSeedProgramMaeIn, c *gin.Context) error {
	this.bindRequest(ctx, in, c)
	return nil
}
func (this *UpdateSeedProgramAppBinder) bindRequestForm(ctx context.Context, in *maes.UpdateSeedProgramMaeIn, c *gin.Context) error {
	s := &in.Request.Form
	s.Id = this.Binder.PostFormStringField("form[id]", c, &in.Context)
	s.Contact = this.Binder.PostFormStringField("form[contact]", c, &in.Context)
	s.Description = this.Binder.PostFormStringField("form[description]", c, &in.Context)
	s.Name = this.Binder.PostFormStringField("form[name]", c, &in.Context)
	s.PlantId = this.Binder.PostFormStringField("form[plant_id]", c, &in.Context)
	return nil
}
func (this *UpdateSeedProgramAppBinder) bindRequest(ctx context.Context, in *maes.UpdateSeedProgramMaeIn, c *gin.Context) error {
	this.bindRequestForm(ctx, in, c)
	return nil
}
