package binders

// |@@| C

import (
	"context"
	"gardening/src/dat/maes"
	"gardening/src/lib/binder"
	"github.com/gin-gonic/gin"
)

type UpdateUserAppBinder struct {
	Binder *binder.Binder
}

func (this *UpdateUserAppBinder) Bind(ctx context.Context, in *maes.UpdateUserMaeIn, c *gin.Context) error {
	this.bindRequest(ctx, in, c)
	return nil
}
func (this *UpdateUserAppBinder) bindRequestForm(ctx context.Context, in *maes.UpdateUserMaeIn, c *gin.Context) error {
	s := &in.Request.Form
	s.Id = this.Binder.PostFormStringField("form[id]", c, &in.Context)
	s.Name = this.Binder.PostFormStringField("form[name]", c, &in.Context)
	return nil
}
func (this *UpdateUserAppBinder) bindRequest(ctx context.Context, in *maes.UpdateUserMaeIn, c *gin.Context) error {
	this.bindRequestForm(ctx, in, c)
	return nil
}
