package completers

// |@@| C

import (
	"context"
	"gardening/src/lib/completer"
	"gardening/src/srv/fetchers"
	"gardening/src/srv/stringers"
)

type GardenCompleter struct {
	GardenFetcher  *fetchers.GardenFetcher
	GardenStringer *stringers.GardenStringer
}

func (this *GardenCompleter) Provide(ctx context.Context, request *completer.AutocompleteRequest) ([]*completer.Item, error) {
	var items []*completer.Item

	mod := this.GardenFetcher.Mod()
	for _, filter := range request.Filters {
		if filter.Key == "id" {
			mod.ExactIdValueFilter("id", filter.Value)
		}
		if filter.Key == "name" {
			mod.ExactStringValueFilter("name", filter.Value)
		}

	}

	entities, err := this.GardenFetcher.FindSet(ctx, mod)
	if err != nil {
		return nil, err
	}
	for _, entity := range entities {
		s, err := this.GardenStringer.ToString(entity)
		if err != nil {
			return nil, err
		}

		item := &completer.Item{
			Id:   entity.Id,
			Text: s,
		}
		items = append(items, item)
	}
	return items, nil

}
