package completers

// |@@| C

import (
	"context"
	"gardening/src/lib/completer"
	"gardening/src/srv/fetchers"
	"gardening/src/srv/stringers"
)

type GardenTaskCompleter struct {
	GardenTaskFetcher  *fetchers.GardenTaskFetcher
	GardenTaskStringer *stringers.GardenTaskStringer
}

func (this *GardenTaskCompleter) Provide(ctx context.Context, request *completer.AutocompleteRequest) ([]*completer.Item, error) {
	var items []*completer.Item

	mod := this.GardenTaskFetcher.Mod()
	for _, filter := range request.Filters {
		if filter.Key == "id" {
			mod.ExactIdValueFilter("id", filter.Value)
		}
		if filter.Key == "name" {
			mod.ExactStringValueFilter("name", filter.Value)
		}
		if filter.Key == "garden_id" {
			mod.ExactIdValueFilter("garden_id", filter.Value)
		}
		if filter.Key == "plantation_id" {
			mod.ExactIdValueFilter("plantation_id", filter.Value)
		}

	}

	entities, err := this.GardenTaskFetcher.FindSet(ctx, mod)
	if err != nil {
		return nil, err
	}
	for _, entity := range entities {
		s, err := this.GardenTaskStringer.ToString(entity)
		if err != nil {
			return nil, err
		}

		item := &completer.Item{
			Id:   entity.Id,
			Text: s,
		}
		items = append(items, item)
	}
	return items, nil

}
