package completers

// |@@| C

import (
	"context"
	"gardening/src/lib/completer"
	"gardening/src/srv/fetchers"
	"gardening/src/srv/stringers"
)

type PlantCompleter struct {
	PlantFetcher  *fetchers.PlantFetcher
	PlantStringer *stringers.PlantStringer
}

func (this *PlantCompleter) Provide(ctx context.Context, request *completer.AutocompleteRequest) ([]*completer.Item, error) {
	var items []*completer.Item

	mod := this.PlantFetcher.Mod()
	for _, filter := range request.Filters {
		if filter.Key == "id" {
			mod.ExactIdValueFilter("id", filter.Value)
		}
		if filter.Key == "exposition" {
			mod.ExactStringValueFilter("exposition", filter.Value)
		}
		if filter.Key == "name" {
			mod.ExactStringValueFilter("name", filter.Value)
		}
		if filter.Key == "reference" {
			mod.ExactStringValueFilter("reference", filter.Value)
		}

	}

	entities, err := this.PlantFetcher.FindSet(ctx, mod)
	if err != nil {
		return nil, err
	}
	for _, entity := range entities {
		s, err := this.PlantStringer.ToString(entity)
		if err != nil {
			return nil, err
		}

		item := &completer.Item{
			Id:   entity.Id,
			Text: s,
		}
		items = append(items, item)
	}
	return items, nil

}
