package completers

// |@@| C

import (
	"context"
	"gardening/src/lib/completer"
	"gardening/src/srv/fetchers"
	"gardening/src/srv/stringers"
)

type PlantTaskCompleter struct {
	PlantTaskFetcher  *fetchers.PlantTaskFetcher
	PlantTaskStringer *stringers.PlantTaskStringer
}

func (this *PlantTaskCompleter) Provide(ctx context.Context, request *completer.AutocompleteRequest) ([]*completer.Item, error) {
	var items []*completer.Item

	mod := this.PlantTaskFetcher.Mod()
	for _, filter := range request.Filters {
		if filter.Key == "id" {
			mod.ExactIdValueFilter("id", filter.Value)
		}
		if filter.Key == "name" {
			mod.ExactStringValueFilter("name", filter.Value)
		}
		if filter.Key == "plant_id" {
			mod.ExactIdValueFilter("plant_id", filter.Value)
		}

	}

	entities, err := this.PlantTaskFetcher.FindSet(ctx, mod)
	if err != nil {
		return nil, err
	}
	for _, entity := range entities {
		s, err := this.PlantTaskStringer.ToString(entity)
		if err != nil {
			return nil, err
		}

		item := &completer.Item{
			Id:   entity.Id,
			Text: s,
		}
		items = append(items, item)
	}
	return items, nil

}
