package completers

// |@@| C

import (
	"context"
	"gardening/src/lib/completer"
	"gardening/src/srv/fetchers"
	"gardening/src/srv/stringers"
)

type SeedProgramCompleter struct {
	SeedProgramFetcher  *fetchers.SeedProgramFetcher
	SeedProgramStringer *stringers.SeedProgramStringer
}

func (this *SeedProgramCompleter) Provide(ctx context.Context, request *completer.AutocompleteRequest) ([]*completer.Item, error) {
	var items []*completer.Item

	mod := this.SeedProgramFetcher.Mod()
	for _, filter := range request.Filters {
		if filter.Key == "id" {
			mod.ExactIdValueFilter("id", filter.Value)
		}
		if filter.Key == "contact" {
			mod.ExactStringValueFilter("contact", filter.Value)
		}
		if filter.Key == "name" {
			mod.ExactStringValueFilter("name", filter.Value)
		}
		if filter.Key == "plant_id" {
			mod.ExactIdValueFilter("plant_id", filter.Value)
		}

	}

	entities, err := this.SeedProgramFetcher.FindSet(ctx, mod)
	if err != nil {
		return nil, err
	}
	for _, entity := range entities {
		s, err := this.SeedProgramStringer.ToString(entity)
		if err != nil {
			return nil, err
		}

		item := &completer.Item{
			Id:   entity.Id,
			Text: s,
		}
		items = append(items, item)
	}
	return items, nil

}
