package fetchers

// |@@| C

import (
	"context"
	"database/sql"
	"gardening/src/lib"
	"gardening/src/lib/fetcher"
	"gardening/src/mdl"
	"gardening/src/srv/tables"
)

type EventFetcher struct {
	EventTable *tables.EventTable
	Fetcher    *fetcher.Fetcher
}

func (this *EventFetcher) FindAll(ctx context.Context, mod *fetcher.FetcherMod) ([]*mdl.Event, error) {
	mod = this.modDefaulting(mod)
	return this.querySet(ctx, mod)
}
func (this *EventFetcher) FindSet(ctx context.Context, mod *fetcher.FetcherMod) ([]*mdl.Event, error) {
	mod = this.modDefaulting(mod)
	return this.querySet(ctx, mod)
}
func (this *EventFetcher) FindSetIn(ctx context.Context, ids []string, mod *fetcher.FetcherMod) ([]*mdl.Event, error) {
	mod = this.modDefaulting(mod)
	mod.InStringValuesFilter("id", ids)
	return this.FindSet(ctx, mod)
}
func (this *EventFetcher) FindPageIn(ctx context.Context, ids []string, mod *fetcher.FetcherMod) ([]*mdl.Event, *fetcher.FetcherPagination, error) {
	mod = this.modDefaulting(mod)
	mod.InStringValuesFilter("id", ids)
	return this.FindPage(ctx, mod)
}
func (this *EventFetcher) FindPage(ctx context.Context, mod *fetcher.FetcherMod) ([]*mdl.Event, *fetcher.FetcherPagination, error) {
	mod = this.modDefaulting(mod)
	set, err := this.queryPage(ctx, mod)
	if err != nil {
		return nil, nil, err
	}
	pagination := this.CountSet(ctx, mod)
	pagination.Modulation = mod
	return set, pagination, nil
}
func (this *EventFetcher) FindOne(ctx context.Context, mod *fetcher.FetcherMod) (*mdl.Event, bool, error) {
	mod = this.modDefaulting(mod)
	return this.queryOne(ctx, mod)
}
func (this *EventFetcher) ShallFindOne(ctx context.Context, mod *fetcher.FetcherMod) *mdl.Event {
	mod = this.modDefaulting(mod)
	p1, has, err := this.FindOne(ctx, mod)
	lib.Poe(err)
	this.Fetcher.MustHave(has, mod)
	return p1
}
func (this *EventFetcher) FindOneById(ctx context.Context, id string, mod *fetcher.FetcherMod) (*mdl.Event, bool, error) {
	mod = this.modDefaulting(mod)
	mod.ExactStringValueFilter("id", id)
	return this.FindOne(ctx, mod)
}
func (this *EventFetcher) ShallFindOneById(ctx context.Context, id string, mod *fetcher.FetcherMod) *mdl.Event {
	mod = this.modDefaulting(mod)
	p1, has, err := this.FindOneById(ctx, id, mod)
	lib.Poe(err)
	this.Fetcher.MustHave(has, mod)
	return p1
}
func (this *EventFetcher) Mod() *fetcher.FetcherMod {
	return &fetcher.FetcherMod{
		Page:    1,
		PerPage: 25,
	}
}
func (this *EventFetcher) buildSelect(ctx context.Context, mod *fetcher.FetcherMod) (string, []interface{}) {
	return this.Fetcher.BuildSelect(mod, this.EventTable.TableName(), this.EventTable.Columns())
}
func (this *EventFetcher) buildCount(ctx context.Context, mod *fetcher.FetcherMod) (string, []interface{}) {
	mod.Count = true
	return this.Fetcher.BuildSelect(mod, this.EventTable.TableName(), this.EventTable.Columns())
}
func (this *EventFetcher) queryOne(ctx context.Context, mod *fetcher.FetcherMod) (*mdl.Event, bool, error) {
	mod.One = true
	query, args := this.buildSelect(ctx, mod)
	eso := &tables.EventEso{}
	row := this.Fetcher.QueryRow(ctx, query, args...)
	err := row.Scan(this.EventTable.EsoToPointers(eso)...)
	if this.Fetcher.IsNoRow(err) {
		return nil, false, nil
	}
	lib.Poe(err)
	entity := this.EventTable.EsoToEntity(eso)
	return entity, true, nil
}
func (this *EventFetcher) querySet(ctx context.Context, mod *fetcher.FetcherMod) ([]*mdl.Event, error) {
	query, args := this.buildSelect(ctx, mod)
	rows, err := this.Fetcher.Query(ctx, query, args...)
	lib.Poe(err)
	set := this.rowsScan(ctx, rows, mod)
	err = rows.Close()
	lib.Poe(err)
	return set, nil
}
func (this *EventFetcher) queryPage(ctx context.Context, mod *fetcher.FetcherMod) ([]*mdl.Event, error) {
	mod.Paginated = true
	return this.querySet(ctx, mod)
}
func (this *EventFetcher) CountSet(ctx context.Context, mod *fetcher.FetcherMod) *fetcher.FetcherPagination {
	pagination := &fetcher.FetcherPagination{}
	query, args := this.buildCount(ctx, mod)
	row := this.Fetcher.QueryRow(ctx, query, args...)
	err := row.Scan(&pagination.Total)
	lib.Poe(err)
	this.Fetcher.CalculatePagination(pagination, mod)
	return pagination
}
func (this *EventFetcher) rowsScan(ctx context.Context, rows *sql.Rows, mod *fetcher.FetcherMod) []*mdl.Event {
	var set []*mdl.Event
	for rows.Next() {
		eso := &tables.EventEso{}
		fields := this.EventTable.EsoToPointers(eso)
		err := rows.Scan(fields...)
		lib.Poe(err)
		entity := this.EventTable.EsoToEntity(eso)
		set = append(set, entity)
	}
	err := rows.Close()
	lib.Poe(err)
	return set
}
func (this *EventFetcher) modDefaulting(mod *fetcher.FetcherMod) *fetcher.FetcherMod {
	if mod == nil {
		return this.Mod()
	}
	return mod
}
func (this *EventFetcher) MustFindAll(ctx context.Context, mod *fetcher.FetcherMod) []*mdl.Event {
	p1, err := this.FindAll(ctx, mod)
	lib.Poe(err)
	return p1
}
func (this *EventFetcher) MustFindSet(ctx context.Context, mod *fetcher.FetcherMod) []*mdl.Event {
	p1, err := this.FindSet(ctx, mod)
	lib.Poe(err)
	return p1
}
func (this *EventFetcher) MustFindSetIn(ctx context.Context, ids []string, mod *fetcher.FetcherMod) []*mdl.Event {
	p1, err := this.FindSetIn(ctx, ids, mod)
	lib.Poe(err)
	return p1
}
func (this *EventFetcher) MustFindPageIn(ctx context.Context, ids []string, mod *fetcher.FetcherMod) ([]*mdl.Event, *fetcher.FetcherPagination) {
	p1, p2, err := this.FindPageIn(ctx, ids, mod)
	lib.Poe(err)
	return p1, p2
}
func (this *EventFetcher) MustFindPage(ctx context.Context, mod *fetcher.FetcherMod) ([]*mdl.Event, *fetcher.FetcherPagination) {
	p1, p2, err := this.FindPage(ctx, mod)
	lib.Poe(err)
	return p1, p2
}
func (this *EventFetcher) MustFindOne(ctx context.Context, mod *fetcher.FetcherMod) (*mdl.Event, bool) {
	p1, p2, err := this.FindOne(ctx, mod)
	lib.Poe(err)
	return p1, p2
}
func (this *EventFetcher) MustFindOneById(ctx context.Context, id string, mod *fetcher.FetcherMod) (*mdl.Event, bool) {
	p1, p2, err := this.FindOneById(ctx, id, mod)
	lib.Poe(err)
	return p1, p2
}
