package fetchers

// |@@| C

import (
	"context"
	"database/sql"
	"gardening/src/lib"
	"gardening/src/lib/fetcher"
	"gardening/src/mdl"
	"gardening/src/srv/tables"
)

type PlantFetcher struct {
	Fetcher    *fetcher.Fetcher
	PlantTable *tables.PlantTable
}

func (this *PlantFetcher) FindAll(ctx context.Context, mod *fetcher.FetcherMod) ([]*mdl.Plant, error) {
	mod = this.modDefaulting(mod)
	return this.querySet(ctx, mod)
}
func (this *PlantFetcher) FindSet(ctx context.Context, mod *fetcher.FetcherMod) ([]*mdl.Plant, error) {
	mod = this.modDefaulting(mod)
	return this.querySet(ctx, mod)
}
func (this *PlantFetcher) FindSetIn(ctx context.Context, ids []string, mod *fetcher.FetcherMod) ([]*mdl.Plant, error) {
	mod = this.modDefaulting(mod)
	mod.InStringValuesFilter("id", ids)
	return this.FindSet(ctx, mod)
}
func (this *PlantFetcher) FindPageIn(ctx context.Context, ids []string, mod *fetcher.FetcherMod) ([]*mdl.Plant, *fetcher.FetcherPagination, error) {
	mod = this.modDefaulting(mod)
	mod.InStringValuesFilter("id", ids)
	return this.FindPage(ctx, mod)
}
func (this *PlantFetcher) FindPage(ctx context.Context, mod *fetcher.FetcherMod) ([]*mdl.Plant, *fetcher.FetcherPagination, error) {
	mod = this.modDefaulting(mod)
	set, err := this.queryPage(ctx, mod)
	if err != nil {
		return nil, nil, err
	}
	pagination := this.CountSet(ctx, mod)
	pagination.Modulation = mod
	return set, pagination, nil
}
func (this *PlantFetcher) FindOne(ctx context.Context, mod *fetcher.FetcherMod) (*mdl.Plant, bool, error) {
	mod = this.modDefaulting(mod)
	return this.queryOne(ctx, mod)
}
func (this *PlantFetcher) ShallFindOne(ctx context.Context, mod *fetcher.FetcherMod) *mdl.Plant {
	mod = this.modDefaulting(mod)
	p1, has, err := this.FindOne(ctx, mod)
	lib.Poe(err)
	this.Fetcher.MustHave(has, mod)
	return p1
}
func (this *PlantFetcher) FindOneById(ctx context.Context, id string, mod *fetcher.FetcherMod) (*mdl.Plant, bool, error) {
	mod = this.modDefaulting(mod)
	mod.ExactStringValueFilter("id", id)
	return this.FindOne(ctx, mod)
}
func (this *PlantFetcher) ShallFindOneById(ctx context.Context, id string, mod *fetcher.FetcherMod) *mdl.Plant {
	mod = this.modDefaulting(mod)
	p1, has, err := this.FindOneById(ctx, id, mod)
	lib.Poe(err)
	this.Fetcher.MustHave(has, mod)
	return p1
}
func (this *PlantFetcher) Mod() *fetcher.FetcherMod {
	return &fetcher.FetcherMod{
		Page:    1,
		PerPage: 25,
	}
}
func (this *PlantFetcher) buildSelect(ctx context.Context, mod *fetcher.FetcherMod) (string, []interface{}) {
	return this.Fetcher.BuildSelect(mod, this.PlantTable.TableName(), this.PlantTable.Columns())
}
func (this *PlantFetcher) buildCount(ctx context.Context, mod *fetcher.FetcherMod) (string, []interface{}) {
	mod.Count = true
	return this.Fetcher.BuildSelect(mod, this.PlantTable.TableName(), this.PlantTable.Columns())
}
func (this *PlantFetcher) queryOne(ctx context.Context, mod *fetcher.FetcherMod) (*mdl.Plant, bool, error) {
	mod.One = true
	query, args := this.buildSelect(ctx, mod)
	eso := &tables.PlantEso{}
	row := this.Fetcher.QueryRow(ctx, query, args...)
	err := row.Scan(this.PlantTable.EsoToPointers(eso)...)
	if this.Fetcher.IsNoRow(err) {
		return nil, false, nil
	}
	lib.Poe(err)
	entity := this.PlantTable.EsoToEntity(eso)
	return entity, true, nil
}
func (this *PlantFetcher) querySet(ctx context.Context, mod *fetcher.FetcherMod) ([]*mdl.Plant, error) {
	query, args := this.buildSelect(ctx, mod)
	rows, err := this.Fetcher.Query(ctx, query, args...)
	lib.Poe(err)
	set := this.rowsScan(ctx, rows, mod)
	err = rows.Close()
	lib.Poe(err)
	return set, nil
}
func (this *PlantFetcher) queryPage(ctx context.Context, mod *fetcher.FetcherMod) ([]*mdl.Plant, error) {
	mod.Paginated = true
	return this.querySet(ctx, mod)
}
func (this *PlantFetcher) CountSet(ctx context.Context, mod *fetcher.FetcherMod) *fetcher.FetcherPagination {
	pagination := &fetcher.FetcherPagination{}
	query, args := this.buildCount(ctx, mod)
	row := this.Fetcher.QueryRow(ctx, query, args...)
	err := row.Scan(&pagination.Total)
	lib.Poe(err)
	this.Fetcher.CalculatePagination(pagination, mod)
	return pagination
}
func (this *PlantFetcher) rowsScan(ctx context.Context, rows *sql.Rows, mod *fetcher.FetcherMod) []*mdl.Plant {
	var set []*mdl.Plant
	for rows.Next() {
		eso := &tables.PlantEso{}
		fields := this.PlantTable.EsoToPointers(eso)
		err := rows.Scan(fields...)
		lib.Poe(err)
		entity := this.PlantTable.EsoToEntity(eso)
		set = append(set, entity)
	}
	err := rows.Close()
	lib.Poe(err)
	return set
}
func (this *PlantFetcher) modDefaulting(mod *fetcher.FetcherMod) *fetcher.FetcherMod {
	if mod == nil {
		return this.Mod()
	}
	return mod
}
func (this *PlantFetcher) MustFindAll(ctx context.Context, mod *fetcher.FetcherMod) []*mdl.Plant {
	p1, err := this.FindAll(ctx, mod)
	lib.Poe(err)
	return p1
}
func (this *PlantFetcher) MustFindSet(ctx context.Context, mod *fetcher.FetcherMod) []*mdl.Plant {
	p1, err := this.FindSet(ctx, mod)
	lib.Poe(err)
	return p1
}
func (this *PlantFetcher) MustFindSetIn(ctx context.Context, ids []string, mod *fetcher.FetcherMod) []*mdl.Plant {
	p1, err := this.FindSetIn(ctx, ids, mod)
	lib.Poe(err)
	return p1
}
func (this *PlantFetcher) MustFindPageIn(ctx context.Context, ids []string, mod *fetcher.FetcherMod) ([]*mdl.Plant, *fetcher.FetcherPagination) {
	p1, p2, err := this.FindPageIn(ctx, ids, mod)
	lib.Poe(err)
	return p1, p2
}
func (this *PlantFetcher) MustFindPage(ctx context.Context, mod *fetcher.FetcherMod) ([]*mdl.Plant, *fetcher.FetcherPagination) {
	p1, p2, err := this.FindPage(ctx, mod)
	lib.Poe(err)
	return p1, p2
}
func (this *PlantFetcher) MustFindOne(ctx context.Context, mod *fetcher.FetcherMod) (*mdl.Plant, bool) {
	p1, p2, err := this.FindOne(ctx, mod)
	lib.Poe(err)
	return p1, p2
}
func (this *PlantFetcher) MustFindOneById(ctx context.Context, id string, mod *fetcher.FetcherMod) (*mdl.Plant, bool) {
	p1, p2, err := this.FindOneById(ctx, id, mod)
	lib.Poe(err)
	return p1, p2
}
