package fetchers

// |@@| C

import (
	"context"
	"database/sql"
	"gardening/src/lib"
	"gardening/src/lib/fetcher"
	"gardening/src/mdl"
	"gardening/src/srv/tables"
)

type PlantTaskFetcher struct {
	Fetcher        *fetcher.Fetcher
	PlantTaskTable *tables.PlantTaskTable
}

func (this *PlantTaskFetcher) FindAll(ctx context.Context, mod *fetcher.FetcherMod) ([]*mdl.PlantTask, error) {
	mod = this.modDefaulting(mod)
	return this.querySet(ctx, mod)
}
func (this *PlantTaskFetcher) FindSet(ctx context.Context, mod *fetcher.FetcherMod) ([]*mdl.PlantTask, error) {
	mod = this.modDefaulting(mod)
	return this.querySet(ctx, mod)
}
func (this *PlantTaskFetcher) FindSetIn(ctx context.Context, ids []string, mod *fetcher.FetcherMod) ([]*mdl.PlantTask, error) {
	mod = this.modDefaulting(mod)
	mod.InStringValuesFilter("id", ids)
	return this.FindSet(ctx, mod)
}
func (this *PlantTaskFetcher) FindPageIn(ctx context.Context, ids []string, mod *fetcher.FetcherMod) ([]*mdl.PlantTask, *fetcher.FetcherPagination, error) {
	mod = this.modDefaulting(mod)
	mod.InStringValuesFilter("id", ids)
	return this.FindPage(ctx, mod)
}
func (this *PlantTaskFetcher) FindSetInPlantIds(ctx context.Context, ids []string, mod *fetcher.FetcherMod) ([]*mdl.PlantTask, error) {
	mod = this.modDefaulting(mod)
	mod.InStringValuesFilter("plant_id", ids)
	return this.FindSet(ctx, mod)
}
func (this *PlantTaskFetcher) FindPage(ctx context.Context, mod *fetcher.FetcherMod) ([]*mdl.PlantTask, *fetcher.FetcherPagination, error) {
	mod = this.modDefaulting(mod)
	set, err := this.queryPage(ctx, mod)
	if err != nil {
		return nil, nil, err
	}
	pagination := this.CountSet(ctx, mod)
	pagination.Modulation = mod
	return set, pagination, nil
}
func (this *PlantTaskFetcher) FindOne(ctx context.Context, mod *fetcher.FetcherMod) (*mdl.PlantTask, bool, error) {
	mod = this.modDefaulting(mod)
	return this.queryOne(ctx, mod)
}
func (this *PlantTaskFetcher) ShallFindOne(ctx context.Context, mod *fetcher.FetcherMod) *mdl.PlantTask {
	mod = this.modDefaulting(mod)
	p1, has, err := this.FindOne(ctx, mod)
	lib.Poe(err)
	this.Fetcher.MustHave(has, mod)
	return p1
}
func (this *PlantTaskFetcher) FindOneById(ctx context.Context, id string, mod *fetcher.FetcherMod) (*mdl.PlantTask, bool, error) {
	mod = this.modDefaulting(mod)
	mod.ExactStringValueFilter("id", id)
	return this.FindOne(ctx, mod)
}
func (this *PlantTaskFetcher) ShallFindOneById(ctx context.Context, id string, mod *fetcher.FetcherMod) *mdl.PlantTask {
	mod = this.modDefaulting(mod)
	p1, has, err := this.FindOneById(ctx, id, mod)
	lib.Poe(err)
	this.Fetcher.MustHave(has, mod)
	return p1
}
func (this *PlantTaskFetcher) FindSetByPlantId(ctx context.Context, plantId string, mod *fetcher.FetcherMod) ([]*mdl.PlantTask, error) {
	mod = this.modDefaulting(mod)
	mod.ExactStringValueFilter("plant_id", plantId)
	return this.FindSet(ctx, mod)
}
func (this *PlantTaskFetcher) Mod() *fetcher.FetcherMod {
	return &fetcher.FetcherMod{
		Page:    1,
		PerPage: 25,
	}
}
func (this *PlantTaskFetcher) buildSelect(ctx context.Context, mod *fetcher.FetcherMod) (string, []interface{}) {
	return this.Fetcher.BuildSelect(mod, this.PlantTaskTable.TableName(), this.PlantTaskTable.Columns())
}
func (this *PlantTaskFetcher) buildCount(ctx context.Context, mod *fetcher.FetcherMod) (string, []interface{}) {
	mod.Count = true
	return this.Fetcher.BuildSelect(mod, this.PlantTaskTable.TableName(), this.PlantTaskTable.Columns())
}
func (this *PlantTaskFetcher) queryOne(ctx context.Context, mod *fetcher.FetcherMod) (*mdl.PlantTask, bool, error) {
	mod.One = true
	query, args := this.buildSelect(ctx, mod)
	eso := &tables.PlantTaskEso{}
	row := this.Fetcher.QueryRow(ctx, query, args...)
	err := row.Scan(this.PlantTaskTable.EsoToPointers(eso)...)
	if this.Fetcher.IsNoRow(err) {
		return nil, false, nil
	}
	lib.Poe(err)
	entity := this.PlantTaskTable.EsoToEntity(eso)
	return entity, true, nil
}
func (this *PlantTaskFetcher) querySet(ctx context.Context, mod *fetcher.FetcherMod) ([]*mdl.PlantTask, error) {
	query, args := this.buildSelect(ctx, mod)
	rows, err := this.Fetcher.Query(ctx, query, args...)
	lib.Poe(err)
	set := this.rowsScan(ctx, rows, mod)
	err = rows.Close()
	lib.Poe(err)
	return set, nil
}
func (this *PlantTaskFetcher) queryPage(ctx context.Context, mod *fetcher.FetcherMod) ([]*mdl.PlantTask, error) {
	mod.Paginated = true
	return this.querySet(ctx, mod)
}
func (this *PlantTaskFetcher) CountSet(ctx context.Context, mod *fetcher.FetcherMod) *fetcher.FetcherPagination {
	pagination := &fetcher.FetcherPagination{}
	query, args := this.buildCount(ctx, mod)
	row := this.Fetcher.QueryRow(ctx, query, args...)
	err := row.Scan(&pagination.Total)
	lib.Poe(err)
	this.Fetcher.CalculatePagination(pagination, mod)
	return pagination
}
func (this *PlantTaskFetcher) rowsScan(ctx context.Context, rows *sql.Rows, mod *fetcher.FetcherMod) []*mdl.PlantTask {
	var set []*mdl.PlantTask
	for rows.Next() {
		eso := &tables.PlantTaskEso{}
		fields := this.PlantTaskTable.EsoToPointers(eso)
		err := rows.Scan(fields...)
		lib.Poe(err)
		entity := this.PlantTaskTable.EsoToEntity(eso)
		set = append(set, entity)
	}
	err := rows.Close()
	lib.Poe(err)
	return set
}
func (this *PlantTaskFetcher) modDefaulting(mod *fetcher.FetcherMod) *fetcher.FetcherMod {
	if mod == nil {
		return this.Mod()
	}
	return mod
}
func (this *PlantTaskFetcher) MustFindAll(ctx context.Context, mod *fetcher.FetcherMod) []*mdl.PlantTask {
	p1, err := this.FindAll(ctx, mod)
	lib.Poe(err)
	return p1
}
func (this *PlantTaskFetcher) MustFindSet(ctx context.Context, mod *fetcher.FetcherMod) []*mdl.PlantTask {
	p1, err := this.FindSet(ctx, mod)
	lib.Poe(err)
	return p1
}
func (this *PlantTaskFetcher) MustFindSetIn(ctx context.Context, ids []string, mod *fetcher.FetcherMod) []*mdl.PlantTask {
	p1, err := this.FindSetIn(ctx, ids, mod)
	lib.Poe(err)
	return p1
}
func (this *PlantTaskFetcher) MustFindPageIn(ctx context.Context, ids []string, mod *fetcher.FetcherMod) ([]*mdl.PlantTask, *fetcher.FetcherPagination) {
	p1, p2, err := this.FindPageIn(ctx, ids, mod)
	lib.Poe(err)
	return p1, p2
}
func (this *PlantTaskFetcher) MustFindSetInPlantIds(ctx context.Context, ids []string, mod *fetcher.FetcherMod) []*mdl.PlantTask {
	p1, err := this.FindSetInPlantIds(ctx, ids, mod)
	lib.Poe(err)
	return p1
}
func (this *PlantTaskFetcher) MustFindPage(ctx context.Context, mod *fetcher.FetcherMod) ([]*mdl.PlantTask, *fetcher.FetcherPagination) {
	p1, p2, err := this.FindPage(ctx, mod)
	lib.Poe(err)
	return p1, p2
}
func (this *PlantTaskFetcher) MustFindOne(ctx context.Context, mod *fetcher.FetcherMod) (*mdl.PlantTask, bool) {
	p1, p2, err := this.FindOne(ctx, mod)
	lib.Poe(err)
	return p1, p2
}
func (this *PlantTaskFetcher) MustFindOneById(ctx context.Context, id string, mod *fetcher.FetcherMod) (*mdl.PlantTask, bool) {
	p1, p2, err := this.FindOneById(ctx, id, mod)
	lib.Poe(err)
	return p1, p2
}
func (this *PlantTaskFetcher) MustFindSetByPlantId(ctx context.Context, plantId string, mod *fetcher.FetcherMod) []*mdl.PlantTask {
	p1, err := this.FindSetByPlantId(ctx, plantId, mod)
	lib.Poe(err)
	return p1
}
