package fetchers

// |@@| C

import (
	"context"
	"database/sql"
	"gardening/src/lib"
	"gardening/src/lib/fetcher"
	"gardening/src/mdl"
	"gardening/src/srv/tables"
)

type SeedProgramFetcher struct {
	Fetcher          *fetcher.Fetcher
	SeedProgramTable *tables.SeedProgramTable
}

func (this *SeedProgramFetcher) FindAll(ctx context.Context, mod *fetcher.FetcherMod) ([]*mdl.SeedProgram, error) {
	mod = this.modDefaulting(mod)
	return this.querySet(ctx, mod)
}
func (this *SeedProgramFetcher) FindSet(ctx context.Context, mod *fetcher.FetcherMod) ([]*mdl.SeedProgram, error) {
	mod = this.modDefaulting(mod)
	return this.querySet(ctx, mod)
}
func (this *SeedProgramFetcher) FindSetIn(ctx context.Context, ids []string, mod *fetcher.FetcherMod) ([]*mdl.SeedProgram, error) {
	mod = this.modDefaulting(mod)
	mod.InStringValuesFilter("id", ids)
	return this.FindSet(ctx, mod)
}
func (this *SeedProgramFetcher) FindPageIn(ctx context.Context, ids []string, mod *fetcher.FetcherMod) ([]*mdl.SeedProgram, *fetcher.FetcherPagination, error) {
	mod = this.modDefaulting(mod)
	mod.InStringValuesFilter("id", ids)
	return this.FindPage(ctx, mod)
}
func (this *SeedProgramFetcher) FindSetInPlantIds(ctx context.Context, ids []string, mod *fetcher.FetcherMod) ([]*mdl.SeedProgram, error) {
	mod = this.modDefaulting(mod)
	mod.InStringValuesFilter("plant_id", ids)
	return this.FindSet(ctx, mod)
}
func (this *SeedProgramFetcher) FindPage(ctx context.Context, mod *fetcher.FetcherMod) ([]*mdl.SeedProgram, *fetcher.FetcherPagination, error) {
	mod = this.modDefaulting(mod)
	set, err := this.queryPage(ctx, mod)
	if err != nil {
		return nil, nil, err
	}
	pagination := this.CountSet(ctx, mod)
	pagination.Modulation = mod
	return set, pagination, nil
}
func (this *SeedProgramFetcher) FindOne(ctx context.Context, mod *fetcher.FetcherMod) (*mdl.SeedProgram, bool, error) {
	mod = this.modDefaulting(mod)
	return this.queryOne(ctx, mod)
}
func (this *SeedProgramFetcher) ShallFindOne(ctx context.Context, mod *fetcher.FetcherMod) *mdl.SeedProgram {
	mod = this.modDefaulting(mod)
	p1, has, err := this.FindOne(ctx, mod)
	lib.Poe(err)
	this.Fetcher.MustHave(has, mod)
	return p1
}
func (this *SeedProgramFetcher) FindOneById(ctx context.Context, id string, mod *fetcher.FetcherMod) (*mdl.SeedProgram, bool, error) {
	mod = this.modDefaulting(mod)
	mod.ExactStringValueFilter("id", id)
	return this.FindOne(ctx, mod)
}
func (this *SeedProgramFetcher) ShallFindOneById(ctx context.Context, id string, mod *fetcher.FetcherMod) *mdl.SeedProgram {
	mod = this.modDefaulting(mod)
	p1, has, err := this.FindOneById(ctx, id, mod)
	lib.Poe(err)
	this.Fetcher.MustHave(has, mod)
	return p1
}
func (this *SeedProgramFetcher) FindSetByPlantId(ctx context.Context, plantId string, mod *fetcher.FetcherMod) ([]*mdl.SeedProgram, error) {
	mod = this.modDefaulting(mod)
	mod.ExactStringValueFilter("plant_id", plantId)
	return this.FindSet(ctx, mod)
}
func (this *SeedProgramFetcher) Mod() *fetcher.FetcherMod {
	return &fetcher.FetcherMod{
		Page:    1,
		PerPage: 25,
	}
}
func (this *SeedProgramFetcher) buildSelect(ctx context.Context, mod *fetcher.FetcherMod) (string, []interface{}) {
	return this.Fetcher.BuildSelect(mod, this.SeedProgramTable.TableName(), this.SeedProgramTable.Columns())
}
func (this *SeedProgramFetcher) buildCount(ctx context.Context, mod *fetcher.FetcherMod) (string, []interface{}) {
	mod.Count = true
	return this.Fetcher.BuildSelect(mod, this.SeedProgramTable.TableName(), this.SeedProgramTable.Columns())
}
func (this *SeedProgramFetcher) queryOne(ctx context.Context, mod *fetcher.FetcherMod) (*mdl.SeedProgram, bool, error) {
	mod.One = true
	query, args := this.buildSelect(ctx, mod)
	eso := &tables.SeedProgramEso{}
	row := this.Fetcher.QueryRow(ctx, query, args...)
	err := row.Scan(this.SeedProgramTable.EsoToPointers(eso)...)
	if this.Fetcher.IsNoRow(err) {
		return nil, false, nil
	}
	lib.Poe(err)
	entity := this.SeedProgramTable.EsoToEntity(eso)
	return entity, true, nil
}
func (this *SeedProgramFetcher) querySet(ctx context.Context, mod *fetcher.FetcherMod) ([]*mdl.SeedProgram, error) {
	query, args := this.buildSelect(ctx, mod)
	rows, err := this.Fetcher.Query(ctx, query, args...)
	lib.Poe(err)
	set := this.rowsScan(ctx, rows, mod)
	err = rows.Close()
	lib.Poe(err)
	return set, nil
}
func (this *SeedProgramFetcher) queryPage(ctx context.Context, mod *fetcher.FetcherMod) ([]*mdl.SeedProgram, error) {
	mod.Paginated = true
	return this.querySet(ctx, mod)
}
func (this *SeedProgramFetcher) CountSet(ctx context.Context, mod *fetcher.FetcherMod) *fetcher.FetcherPagination {
	pagination := &fetcher.FetcherPagination{}
	query, args := this.buildCount(ctx, mod)
	row := this.Fetcher.QueryRow(ctx, query, args...)
	err := row.Scan(&pagination.Total)
	lib.Poe(err)
	this.Fetcher.CalculatePagination(pagination, mod)
	return pagination
}
func (this *SeedProgramFetcher) rowsScan(ctx context.Context, rows *sql.Rows, mod *fetcher.FetcherMod) []*mdl.SeedProgram {
	var set []*mdl.SeedProgram
	for rows.Next() {
		eso := &tables.SeedProgramEso{}
		fields := this.SeedProgramTable.EsoToPointers(eso)
		err := rows.Scan(fields...)
		lib.Poe(err)
		entity := this.SeedProgramTable.EsoToEntity(eso)
		set = append(set, entity)
	}
	err := rows.Close()
	lib.Poe(err)
	return set
}
func (this *SeedProgramFetcher) modDefaulting(mod *fetcher.FetcherMod) *fetcher.FetcherMod {
	if mod == nil {
		return this.Mod()
	}
	return mod
}
func (this *SeedProgramFetcher) MustFindAll(ctx context.Context, mod *fetcher.FetcherMod) []*mdl.SeedProgram {
	p1, err := this.FindAll(ctx, mod)
	lib.Poe(err)
	return p1
}
func (this *SeedProgramFetcher) MustFindSet(ctx context.Context, mod *fetcher.FetcherMod) []*mdl.SeedProgram {
	p1, err := this.FindSet(ctx, mod)
	lib.Poe(err)
	return p1
}
func (this *SeedProgramFetcher) MustFindSetIn(ctx context.Context, ids []string, mod *fetcher.FetcherMod) []*mdl.SeedProgram {
	p1, err := this.FindSetIn(ctx, ids, mod)
	lib.Poe(err)
	return p1
}
func (this *SeedProgramFetcher) MustFindPageIn(ctx context.Context, ids []string, mod *fetcher.FetcherMod) ([]*mdl.SeedProgram, *fetcher.FetcherPagination) {
	p1, p2, err := this.FindPageIn(ctx, ids, mod)
	lib.Poe(err)
	return p1, p2
}
func (this *SeedProgramFetcher) MustFindSetInPlantIds(ctx context.Context, ids []string, mod *fetcher.FetcherMod) []*mdl.SeedProgram {
	p1, err := this.FindSetInPlantIds(ctx, ids, mod)
	lib.Poe(err)
	return p1
}
func (this *SeedProgramFetcher) MustFindPage(ctx context.Context, mod *fetcher.FetcherMod) ([]*mdl.SeedProgram, *fetcher.FetcherPagination) {
	p1, p2, err := this.FindPage(ctx, mod)
	lib.Poe(err)
	return p1, p2
}
func (this *SeedProgramFetcher) MustFindOne(ctx context.Context, mod *fetcher.FetcherMod) (*mdl.SeedProgram, bool) {
	p1, p2, err := this.FindOne(ctx, mod)
	lib.Poe(err)
	return p1, p2
}
func (this *SeedProgramFetcher) MustFindOneById(ctx context.Context, id string, mod *fetcher.FetcherMod) (*mdl.SeedProgram, bool) {
	p1, p2, err := this.FindOneById(ctx, id, mod)
	lib.Poe(err)
	return p1, p2
}
func (this *SeedProgramFetcher) MustFindSetByPlantId(ctx context.Context, plantId string, mod *fetcher.FetcherMod) []*mdl.SeedProgram {
	p1, err := this.FindSetByPlantId(ctx, plantId, mod)
	lib.Poe(err)
	return p1
}
