package fetchers

// |@@| C

import (
	"context"
	"database/sql"
	"gardening/src/lib"
	"gardening/src/lib/fetcher"
	"gardening/src/mdl"
	"gardening/src/srv/tables"
)

type UserFetcher struct {
	Fetcher   *fetcher.Fetcher
	UserTable *tables.UserTable
}

func (this *UserFetcher) FindAll(ctx context.Context, mod *fetcher.FetcherMod) ([]*mdl.User, error) {
	mod = this.modDefaulting(mod)
	return this.querySet(ctx, mod)
}
func (this *UserFetcher) FindSet(ctx context.Context, mod *fetcher.FetcherMod) ([]*mdl.User, error) {
	mod = this.modDefaulting(mod)
	return this.querySet(ctx, mod)
}
func (this *UserFetcher) FindSetIn(ctx context.Context, ids []string, mod *fetcher.FetcherMod) ([]*mdl.User, error) {
	mod = this.modDefaulting(mod)
	mod.InStringValuesFilter("id", ids)
	return this.FindSet(ctx, mod)
}
func (this *UserFetcher) FindPageIn(ctx context.Context, ids []string, mod *fetcher.FetcherMod) ([]*mdl.User, *fetcher.FetcherPagination, error) {
	mod = this.modDefaulting(mod)
	mod.InStringValuesFilter("id", ids)
	return this.FindPage(ctx, mod)
}
func (this *UserFetcher) FindPage(ctx context.Context, mod *fetcher.FetcherMod) ([]*mdl.User, *fetcher.FetcherPagination, error) {
	mod = this.modDefaulting(mod)
	set, err := this.queryPage(ctx, mod)
	if err != nil {
		return nil, nil, err
	}
	pagination := this.CountSet(ctx, mod)
	pagination.Modulation = mod
	return set, pagination, nil
}
func (this *UserFetcher) FindOne(ctx context.Context, mod *fetcher.FetcherMod) (*mdl.User, bool, error) {
	mod = this.modDefaulting(mod)
	return this.queryOne(ctx, mod)
}
func (this *UserFetcher) ShallFindOne(ctx context.Context, mod *fetcher.FetcherMod) *mdl.User {
	mod = this.modDefaulting(mod)
	p1, has, err := this.FindOne(ctx, mod)
	lib.Poe(err)
	this.Fetcher.MustHave(has, mod)
	return p1
}
func (this *UserFetcher) FindOneById(ctx context.Context, id string, mod *fetcher.FetcherMod) (*mdl.User, bool, error) {
	mod = this.modDefaulting(mod)
	mod.ExactStringValueFilter("id", id)
	return this.FindOne(ctx, mod)
}
func (this *UserFetcher) ShallFindOneById(ctx context.Context, id string, mod *fetcher.FetcherMod) *mdl.User {
	mod = this.modDefaulting(mod)
	p1, has, err := this.FindOneById(ctx, id, mod)
	lib.Poe(err)
	this.Fetcher.MustHave(has, mod)
	return p1
}
func (this *UserFetcher) Mod() *fetcher.FetcherMod {
	return &fetcher.FetcherMod{
		Page:    1,
		PerPage: 25,
	}
}
func (this *UserFetcher) buildSelect(ctx context.Context, mod *fetcher.FetcherMod) (string, []interface{}) {
	return this.Fetcher.BuildSelect(mod, this.UserTable.TableName(), this.UserTable.Columns())
}
func (this *UserFetcher) buildCount(ctx context.Context, mod *fetcher.FetcherMod) (string, []interface{}) {
	mod.Count = true
	return this.Fetcher.BuildSelect(mod, this.UserTable.TableName(), this.UserTable.Columns())
}
func (this *UserFetcher) queryOne(ctx context.Context, mod *fetcher.FetcherMod) (*mdl.User, bool, error) {
	mod.One = true
	query, args := this.buildSelect(ctx, mod)
	eso := &tables.UserEso{}
	row := this.Fetcher.QueryRow(ctx, query, args...)
	err := row.Scan(this.UserTable.EsoToPointers(eso)...)
	if this.Fetcher.IsNoRow(err) {
		return nil, false, nil
	}
	lib.Poe(err)
	entity := this.UserTable.EsoToEntity(eso)
	return entity, true, nil
}
func (this *UserFetcher) querySet(ctx context.Context, mod *fetcher.FetcherMod) ([]*mdl.User, error) {
	query, args := this.buildSelect(ctx, mod)
	rows, err := this.Fetcher.Query(ctx, query, args...)
	lib.Poe(err)
	set := this.rowsScan(ctx, rows, mod)
	err = rows.Close()
	lib.Poe(err)
	return set, nil
}
func (this *UserFetcher) queryPage(ctx context.Context, mod *fetcher.FetcherMod) ([]*mdl.User, error) {
	mod.Paginated = true
	return this.querySet(ctx, mod)
}
func (this *UserFetcher) CountSet(ctx context.Context, mod *fetcher.FetcherMod) *fetcher.FetcherPagination {
	pagination := &fetcher.FetcherPagination{}
	query, args := this.buildCount(ctx, mod)
	row := this.Fetcher.QueryRow(ctx, query, args...)
	err := row.Scan(&pagination.Total)
	lib.Poe(err)
	this.Fetcher.CalculatePagination(pagination, mod)
	return pagination
}
func (this *UserFetcher) rowsScan(ctx context.Context, rows *sql.Rows, mod *fetcher.FetcherMod) []*mdl.User {
	var set []*mdl.User
	for rows.Next() {
		eso := &tables.UserEso{}
		fields := this.UserTable.EsoToPointers(eso)
		err := rows.Scan(fields...)
		lib.Poe(err)
		entity := this.UserTable.EsoToEntity(eso)
		set = append(set, entity)
	}
	err := rows.Close()
	lib.Poe(err)
	return set
}
func (this *UserFetcher) modDefaulting(mod *fetcher.FetcherMod) *fetcher.FetcherMod {
	if mod == nil {
		return this.Mod()
	}
	return mod
}
func (this *UserFetcher) MustFindAll(ctx context.Context, mod *fetcher.FetcherMod) []*mdl.User {
	p1, err := this.FindAll(ctx, mod)
	lib.Poe(err)
	return p1
}
func (this *UserFetcher) MustFindSet(ctx context.Context, mod *fetcher.FetcherMod) []*mdl.User {
	p1, err := this.FindSet(ctx, mod)
	lib.Poe(err)
	return p1
}
func (this *UserFetcher) MustFindSetIn(ctx context.Context, ids []string, mod *fetcher.FetcherMod) []*mdl.User {
	p1, err := this.FindSetIn(ctx, ids, mod)
	lib.Poe(err)
	return p1
}
func (this *UserFetcher) MustFindPageIn(ctx context.Context, ids []string, mod *fetcher.FetcherMod) ([]*mdl.User, *fetcher.FetcherPagination) {
	p1, p2, err := this.FindPageIn(ctx, ids, mod)
	lib.Poe(err)
	return p1, p2
}
func (this *UserFetcher) MustFindPage(ctx context.Context, mod *fetcher.FetcherMod) ([]*mdl.User, *fetcher.FetcherPagination) {
	p1, p2, err := this.FindPage(ctx, mod)
	lib.Poe(err)
	return p1, p2
}
func (this *UserFetcher) MustFindOne(ctx context.Context, mod *fetcher.FetcherMod) (*mdl.User, bool) {
	p1, p2, err := this.FindOne(ctx, mod)
	lib.Poe(err)
	return p1, p2
}
func (this *UserFetcher) MustFindOneById(ctx context.Context, id string, mod *fetcher.FetcherMod) (*mdl.User, bool) {
	p1, p2, err := this.FindOneById(ctx, id, mod)
	lib.Poe(err)
	return p1, p2
}
