package form_presenters

// |@@| C

import (
	"gardening/src/dat/forms"
	"gardening/src/lib/error"
	"gardening/src/lib/kit"
	"gardening/src/lib/presenter"
	"gitlab.com/ccyrillee/kitcla/goc"
	u "gitlab.com/ccyrillee/kitcla/goc_utils"
)

type CreateGardenFormPresenter struct {
	Kit       *kit.Kit
	Presenter *presenter.Presenter
}

func (this *CreateGardenFormPresenter) nameField(form *forms.CreateGardenForm, formField *presenter.FormField) goc.HTML {
	field := this.Kit.Atoms.Fields.Field
	name := "form[name]"
	return field.Field("Name", this.Kit.Atoms.Inputs.TextInput.TextInput(name, form.Name))
}
func (this *CreateGardenFormPresenter) pictureField(form *forms.CreateGardenForm, formField *presenter.FormField) goc.HTML {
	field := this.Kit.Atoms.Fields.Field
	name := "form[picture]"
	v1 := this.Kit.Atoms.Inputs.TextInput.TextInput(name, form.Picture)
	v2 := this.Kit.Atoms.Inputs.FileInput.FileInput("picture")
	return field.Field("Picture", u.Ds(v1, v2))
}
func (this *CreateGardenFormPresenter) GetFields() []*presenter.FormField {
	var formFields []*presenter.FormField
	formFields = append(formFields, &presenter.FormField{
		Key:   "name",
		Label: "Name",
	})
	formFields = append(formFields, &presenter.FormField{
		Key:   "picture",
		Label: "Picture",
	})
	return formFields
}
func (this *CreateGardenFormPresenter) FieldByKey(form *forms.CreateGardenForm, formField *presenter.FormField) goc.HTML {
	switch formField.Key {
	case "name":
		return this.nameField(form, formField)
	case "picture":
		return this.pictureField(form, formField)
	}
	panic(erro.N("Invalid form field").KV("key", formField.Key))
}
func (this *CreateGardenFormPresenter) Setup(form *forms.CreateGardenForm) []*presenter.FormField {
	fields := this.GetFields()
	return fields
}
