package form_presenters

// |@@| C

import (
	"gardening/src/dat/forms"
	"gardening/src/lib/error"
	"gardening/src/lib/kit"
	"gardening/src/lib/presenter"
	"gitlab.com/ccyrillee/kitcla/goc"
)

type CreateGardenTaskFormPresenter struct {
	Kit       *kit.Kit
	Presenter *presenter.Presenter
}

func (this *CreateGardenTaskFormPresenter) descriptionField(form *forms.CreateGardenTaskForm, formField *presenter.FormField) goc.HTML {
	field := this.Kit.Atoms.Fields.Field
	name := "form[description]"
	return field.Field("Description", this.Kit.Atoms.Inputs.TextInput.TextInput(name, form.Description))
}
func (this *CreateGardenTaskFormPresenter) nameField(form *forms.CreateGardenTaskForm, formField *presenter.FormField) goc.HTML {
	field := this.Kit.Atoms.Fields.Field
	name := "form[name]"
	return field.Field("Name", this.Kit.Atoms.Inputs.TextInput.TextInput(name, form.Name))
}
func (this *CreateGardenTaskFormPresenter) startDateField(form *forms.CreateGardenTaskForm, formField *presenter.FormField) goc.HTML {
	field := this.Kit.Atoms.Fields.Field
	name := "form[start_date]"
	return field.Field("Start Date", this.Kit.Atoms.Inputs.DatetimeInput.DatetimeInput(name, form.StartDate.Format("2006-01-02T15:04:05")))
}
func (this *CreateGardenTaskFormPresenter) gardenIdField(form *forms.CreateGardenTaskForm, formField *presenter.FormField) goc.HTML {
	field := this.Kit.Atoms.Fields.Field
	name := "form[garden_id]"
	return field.Field("Garden", this.Kit.Atoms.Inputs.AdvancedSelectInput.AdvancedSelectInput2(name, form.GardenId, "gardens", nil))
}
func (this *CreateGardenTaskFormPresenter) plantationIdField(form *forms.CreateGardenTaskForm, formField *presenter.FormField) goc.HTML {
	field := this.Kit.Atoms.Fields.Field
	name := "form[plantation_id]"
	return field.Field("Plantation", this.Kit.Atoms.Inputs.AdvancedSelectInput.AdvancedSelectInput2(name, form.PlantationId, "plantations", nil))
}
func (this *CreateGardenTaskFormPresenter) GetFields() []*presenter.FormField {
	var formFields []*presenter.FormField
	formFields = append(formFields, &presenter.FormField{
		Key:   "description",
		Label: "Description",
	})
	formFields = append(formFields, &presenter.FormField{
		Key:   "name",
		Label: "Name",
	})
	formFields = append(formFields, &presenter.FormField{
		Key:   "start_date",
		Label: "Start Date",
	})
	formFields = append(formFields, &presenter.FormField{
		Key:   "garden_id",
		Label: "Garden",
	})
	formFields = append(formFields, &presenter.FormField{
		Key:   "plantation_id",
		Label: "Plantation",
	})
	return formFields
}
func (this *CreateGardenTaskFormPresenter) FieldByKey(form *forms.CreateGardenTaskForm, formField *presenter.FormField) goc.HTML {
	switch formField.Key {
	case "description":
		return this.descriptionField(form, formField)
	case "name":
		return this.nameField(form, formField)
	case "start_date":
		return this.startDateField(form, formField)
	case "garden_id":
		return this.gardenIdField(form, formField)
	case "plantation_id":
		return this.plantationIdField(form, formField)
	}
	panic(erro.N("Invalid form field").KV("key", formField.Key))
}
func (this *CreateGardenTaskFormPresenter) Setup(form *forms.CreateGardenTaskForm) []*presenter.FormField {
	fields := this.GetFields()
	return fields
}
