package form_presenters

// |@@| C

import (
	"gardening/src/dat/forms"
	"gardening/src/lib/error"
	"gardening/src/lib/kit"
	"gardening/src/lib/presenter"
	"gitlab.com/ccyrillee/kitcla/goc"
)

type CreatePlantFormPresenter struct {
	Kit       *kit.Kit
	Presenter *presenter.Presenter
}

func (this *CreatePlantFormPresenter) dataField(form *forms.CreatePlantForm, formField *presenter.FormField) goc.HTML {
	field := this.Kit.Atoms.Fields.Field
	name := "form[data]"
	return field.Field("Data", this.Kit.Atoms.Inputs.JsonInput.JsonInput(name, form.Data))
}
func (this *CreatePlantFormPresenter) descriptionField(form *forms.CreatePlantForm, formField *presenter.FormField) goc.HTML {
	field := this.Kit.Atoms.Fields.Field
	name := "form[description]"
	return field.Field("Description", this.Kit.Atoms.Inputs.TextInput.TextInput(name, form.Description))
}
func (this *CreatePlantFormPresenter) expositionField(form *forms.CreatePlantForm, formField *presenter.FormField) goc.HTML {
	field := this.Kit.Atoms.Fields.Field
	name := "form[exposition]"
	return field.Field("Exposition", this.Kit.Atoms.Inputs.TextInput.TextInput(name, form.Exposition))
}
func (this *CreatePlantFormPresenter) harvestedField(form *forms.CreatePlantForm, formField *presenter.FormField) goc.HTML {
	field := this.Kit.Atoms.Fields.Field
	name := "form[harvested]"
	return field.Field("Harvested", this.Kit.Atoms.Inputs.DecimalInput.DecimalInput(name, form.Harvested))
}
func (this *CreatePlantFormPresenter) nameField(form *forms.CreatePlantForm, formField *presenter.FormField) goc.HTML {
	field := this.Kit.Atoms.Fields.Field
	name := "form[name]"
	return field.Field("Name", this.Kit.Atoms.Inputs.TextInput.TextInput(name, form.Name))
}
func (this *CreatePlantFormPresenter) perennialField(form *forms.CreatePlantForm, formField *presenter.FormField) goc.HTML {
	field := this.Kit.Atoms.Fields.Field
	name := "form[perennial]"
	return field.Field("Perennial", this.Kit.Atoms.Inputs.BooleanInput.BooleanInput(name, form.Perennial))
}
func (this *CreatePlantFormPresenter) referenceField(form *forms.CreatePlantForm, formField *presenter.FormField) goc.HTML {
	field := this.Kit.Atoms.Fields.Field
	name := "form[reference]"
	return field.Field("Reference", this.Kit.Atoms.Inputs.TextInput.TextInput(name, form.Reference))
}
func (this *CreatePlantFormPresenter) sizeField(form *forms.CreatePlantForm, formField *presenter.FormField) goc.HTML {
	field := this.Kit.Atoms.Fields.Field
	name := "form[size]"
	return field.Field("Size", this.Kit.Atoms.Inputs.IntegerInput.IntegerInput(name, form.Size))
}
func (this *CreatePlantFormPresenter) GetFields() []*presenter.FormField {
	var formFields []*presenter.FormField
	formFields = append(formFields, &presenter.FormField{
		Key:   "data",
		Label: "Data",
	})
	formFields = append(formFields, &presenter.FormField{
		Key:   "description",
		Label: "Description",
	})
	formFields = append(formFields, &presenter.FormField{
		Key:   "exposition",
		Label: "Exposition",
	})
	formFields = append(formFields, &presenter.FormField{
		Key:   "harvested",
		Label: "Harvested",
	})
	formFields = append(formFields, &presenter.FormField{
		Key:   "name",
		Label: "Name",
	})
	formFields = append(formFields, &presenter.FormField{
		Key:   "perennial",
		Label: "Perennial",
	})
	formFields = append(formFields, &presenter.FormField{
		Key:   "reference",
		Label: "Reference",
	})
	formFields = append(formFields, &presenter.FormField{
		Key:   "size",
		Label: "Size",
	})
	return formFields
}
func (this *CreatePlantFormPresenter) FieldByKey(form *forms.CreatePlantForm, formField *presenter.FormField) goc.HTML {
	switch formField.Key {
	case "data":
		return this.dataField(form, formField)
	case "description":
		return this.descriptionField(form, formField)
	case "exposition":
		return this.expositionField(form, formField)
	case "harvested":
		return this.harvestedField(form, formField)
	case "name":
		return this.nameField(form, formField)
	case "perennial":
		return this.perennialField(form, formField)
	case "reference":
		return this.referenceField(form, formField)
	case "size":
		return this.sizeField(form, formField)
	}
	panic(erro.N("Invalid form field").KV("key", formField.Key))
}
func (this *CreatePlantFormPresenter) Setup(form *forms.CreatePlantForm) []*presenter.FormField {
	fields := this.GetFields()
	return fields
}
