package form_presenters

// |@@| C

import (
	"gardening/src/dat/forms"
	"gardening/src/lib/error"
	"gardening/src/lib/kit"
	"gardening/src/lib/presenter"
	"gitlab.com/ccyrillee/kitcla/goc"
)

type CreatePlantTaskFormPresenter struct {
	Kit       *kit.Kit
	Presenter *presenter.Presenter
}

func (this *CreatePlantTaskFormPresenter) descriptionField(form *forms.CreatePlantTaskForm, formField *presenter.FormField) goc.HTML {
	field := this.Kit.Atoms.Fields.Field
	name := "form[description]"
	return field.Field("Description", this.Kit.Atoms.Inputs.TextInput.TextInput(name, form.Description))
}
func (this *CreatePlantTaskFormPresenter) nameField(form *forms.CreatePlantTaskForm, formField *presenter.FormField) goc.HTML {
	field := this.Kit.Atoms.Fields.Field
	name := "form[name]"
	return field.Field("Name", this.Kit.Atoms.Inputs.TextInput.TextInput(name, form.Name))
}
func (this *CreatePlantTaskFormPresenter) startDateField(form *forms.CreatePlantTaskForm, formField *presenter.FormField) goc.HTML {
	field := this.Kit.Atoms.Fields.Field
	name := "form[start_date]"
	return field.Field("Start Date", this.Kit.Atoms.Inputs.DatetimeInput.DatetimeInput(name, form.StartDate.Format("2006-01-02T15:04:05")))
}
func (this *CreatePlantTaskFormPresenter) plantIdField(form *forms.CreatePlantTaskForm, formField *presenter.FormField) goc.HTML {
	field := this.Kit.Atoms.Fields.Field
	name := "form[plant_id]"
	return field.Field("Plant", this.Kit.Atoms.Inputs.AdvancedSelectInput.AdvancedSelectInput2(name, form.PlantId, "plants", nil))
}
func (this *CreatePlantTaskFormPresenter) sendEmailField(form *forms.CreatePlantTaskForm, formField *presenter.FormField) goc.HTML {
	field := this.Kit.Atoms.Fields.Field
	name := "form[send_email]"
	return field.Field("Send Email", this.Kit.Atoms.Inputs.BooleanInput.BooleanInput(name, form.SendEmail))
}
func (this *CreatePlantTaskFormPresenter) GetFields() []*presenter.FormField {
	var formFields []*presenter.FormField
	formFields = append(formFields, &presenter.FormField{
		Key:   "description",
		Label: "Description",
	})
	formFields = append(formFields, &presenter.FormField{
		Key:   "name",
		Label: "Name",
	})
	formFields = append(formFields, &presenter.FormField{
		Key:    "start_date",
		Label:  "Start Date",
		Hidden: true,
	})
	formFields = append(formFields, &presenter.FormField{
		Key:   "plant_id",
		Label: "Plant",
	})
	formFields = append(formFields, &presenter.FormField{
		Key:   "send_email",
		Label: "Send Email",
	})
	return formFields
}
func (this *CreatePlantTaskFormPresenter) FieldByKey(form *forms.CreatePlantTaskForm, formField *presenter.FormField) goc.HTML {
	switch formField.Key {
	case "description":
		return this.descriptionField(form, formField)
	case "name":
		return this.nameField(form, formField)
	case "start_date":
		return this.startDateField(form, formField)
	case "plant_id":
		return this.plantIdField(form, formField)
	case "send_email":
		return this.sendEmailField(form, formField)
	}
	panic(erro.N("Invalid form field").KV("key", formField.Key))
}
func (this *CreatePlantTaskFormPresenter) Setup(form *forms.CreatePlantTaskForm) []*presenter.FormField {
	fields := this.GetFields()
	return fields
}
