package form_presenters

// |@@| C

import (
	"gardening/src/dat/forms"
	"gardening/src/lib/error"
	"gardening/src/lib/kit"
	"gardening/src/lib/presenter"
	"gitlab.com/ccyrillee/kitcla/goc"
)

type CreatePlantationFormPresenter struct {
	Kit       *kit.Kit
	Presenter *presenter.Presenter
}

func (this *CreatePlantationFormPresenter) nameField(form *forms.CreatePlantationForm, formField *presenter.FormField) goc.HTML {
	field := this.Kit.Atoms.Fields.Field
	name := "form[name]"
	return field.Field("Name", this.Kit.Atoms.Inputs.TextInput.TextInput(name, form.Name))
}
func (this *CreatePlantationFormPresenter) plantedAtField(form *forms.CreatePlantationForm, formField *presenter.FormField) goc.HTML {
	field := this.Kit.Atoms.Fields.Field
	name := "form[planted_at]"
	return field.Field("Planted At", this.Kit.Atoms.Inputs.DatetimeInput.DatetimeInput(name, form.PlantedAt.Format("2006-01-02T15:04:05")))
}
func (this *CreatePlantationFormPresenter) plantIdField(form *forms.CreatePlantationForm, formField *presenter.FormField) goc.HTML {
	field := this.Kit.Atoms.Fields.Field
	name := "form[plant_id]"
	return field.Field("Plant", this.Kit.Atoms.Inputs.AdvancedSelectInput.AdvancedSelectInput2(name, form.PlantId, "plants", nil))
}
func (this *CreatePlantationFormPresenter) gardenIdField(form *forms.CreatePlantationForm, formField *presenter.FormField) goc.HTML {
	field := this.Kit.Atoms.Fields.Field
	name := "form[garden_id]"
	return field.Field("Garden", this.Kit.Atoms.Inputs.AdvancedSelectInput.AdvancedSelectInput2(name, form.GardenId, "gardens", nil))
}
func (this *CreatePlantationFormPresenter) GetFields() []*presenter.FormField {
	var formFields []*presenter.FormField
	formFields = append(formFields, &presenter.FormField{
		Key:   "name",
		Label: "Name",
	})
	formFields = append(formFields, &presenter.FormField{
		Key:   "planted_at",
		Label: "Planted At",
	})
	formFields = append(formFields, &presenter.FormField{
		Key:   "plant_id",
		Label: "Plant",
	})
	formFields = append(formFields, &presenter.FormField{
		Key:   "garden_id",
		Label: "Garden",
	})
	return formFields
}
func (this *CreatePlantationFormPresenter) FieldByKey(form *forms.CreatePlantationForm, formField *presenter.FormField) goc.HTML {
	switch formField.Key {
	case "name":
		return this.nameField(form, formField)
	case "planted_at":
		return this.plantedAtField(form, formField)
	case "plant_id":
		return this.plantIdField(form, formField)
	case "garden_id":
		return this.gardenIdField(form, formField)
	}
	panic(erro.N("Invalid form field").KV("key", formField.Key))
}
func (this *CreatePlantationFormPresenter) Setup(form *forms.CreatePlantationForm) []*presenter.FormField {
	fields := this.GetFields()
	return fields
}
