package form_presenters

// |@@| C

import (
	"gardening/src/dat/forms"
	"gardening/src/lib/error"
	"gardening/src/lib/kit"
	"gardening/src/lib/presenter"
	"gitlab.com/ccyrillee/kitcla/goc"
)

type CreateSeedProgramFormPresenter struct {
	Kit       *kit.Kit
	Presenter *presenter.Presenter
}

func (this *CreateSeedProgramFormPresenter) contactField(form *forms.CreateSeedProgramForm, formField *presenter.FormField) goc.HTML {
	field := this.Kit.Atoms.Fields.Field
	name := "form[contact]"
	return field.Field("Contact", this.Kit.Atoms.Inputs.TextInput.TextInput(name, form.Contact))
}
func (this *CreateSeedProgramFormPresenter) descriptionField(form *forms.CreateSeedProgramForm, formField *presenter.FormField) goc.HTML {
	field := this.Kit.Atoms.Fields.Field
	name := "form[description]"
	return field.Field("Description", this.Kit.Atoms.Inputs.TextInput.TextInput(name, form.Description))
}
func (this *CreateSeedProgramFormPresenter) nameField(form *forms.CreateSeedProgramForm, formField *presenter.FormField) goc.HTML {
	field := this.Kit.Atoms.Fields.Field
	name := "form[name]"
	return field.Field("Name", this.Kit.Atoms.Inputs.TextInput.TextInput(name, form.Name))
}
func (this *CreateSeedProgramFormPresenter) plantIdField(form *forms.CreateSeedProgramForm, formField *presenter.FormField) goc.HTML {
	field := this.Kit.Atoms.Fields.Field
	name := "form[plant_id]"
	return field.Field("Plant", this.Kit.Atoms.Inputs.AdvancedSelectInput.AdvancedSelectInput2(name, form.PlantId, "plants", nil))
}
func (this *CreateSeedProgramFormPresenter) GetFields() []*presenter.FormField {
	var formFields []*presenter.FormField
	formFields = append(formFields, &presenter.FormField{
		Key:   "contact",
		Label: "Contact",
	})
	formFields = append(formFields, &presenter.FormField{
		Key:   "description",
		Label: "Description",
	})
	formFields = append(formFields, &presenter.FormField{
		Key:   "name",
		Label: "Name",
	})
	formFields = append(formFields, &presenter.FormField{
		Key:   "plant_id",
		Label: "Plant",
	})
	return formFields
}
func (this *CreateSeedProgramFormPresenter) FieldByKey(form *forms.CreateSeedProgramForm, formField *presenter.FormField) goc.HTML {
	switch formField.Key {
	case "contact":
		return this.contactField(form, formField)
	case "description":
		return this.descriptionField(form, formField)
	case "name":
		return this.nameField(form, formField)
	case "plant_id":
		return this.plantIdField(form, formField)
	}
	panic(erro.N("Invalid form field").KV("key", formField.Key))
}
func (this *CreateSeedProgramFormPresenter) Setup(form *forms.CreateSeedProgramForm) []*presenter.FormField {
	fields := this.GetFields()
	return fields
}
