package form_presenters

// |@@| C

import (
	"gardening/src/dat/forms"
	"gardening/src/lib/error"
	"gardening/src/lib/kit"
	"gardening/src/lib/presenter"
	"gitlab.com/ccyrillee/kitcla/goc"
)

type CreateUserFormPresenter struct {
	Kit       *kit.Kit
	Presenter *presenter.Presenter
}

func (this *CreateUserFormPresenter) nameField(form *forms.CreateUserForm, formField *presenter.FormField) goc.HTML {
	field := this.Kit.Atoms.Fields.Field
	name := "form[name]"
	return field.Field("Name", this.Kit.Atoms.Inputs.TextInput.TextInput(name, form.Name))
}
func (this *CreateUserFormPresenter) GetFields() []*presenter.FormField {
	var formFields []*presenter.FormField
	formFields = append(formFields, &presenter.FormField{
		Key:   "name",
		Label: "Name",
	})
	return formFields
}
func (this *CreateUserFormPresenter) FieldByKey(form *forms.CreateUserForm, formField *presenter.FormField) goc.HTML {
	switch formField.Key {
	case "name":
		return this.nameField(form, formField)
	}
	panic(erro.N("Invalid form field").KV("key", formField.Key))
}
func (this *CreateUserFormPresenter) Setup(form *forms.CreateUserForm) []*presenter.FormField {
	fields := this.GetFields()
	return fields
}
