package form_presenters

// |@@| C

import (
	"gardening/src/dat/forms"
	"gardening/src/lib/error"
	"gardening/src/lib/kit"
	"gardening/src/lib/presenter"
	"gitlab.com/ccyrillee/kitcla/goc"
)

type PerformRenewOrdersFormPresenter struct {
	Kit       *kit.Kit
	Presenter *presenter.Presenter
}

func (this *PerformRenewOrdersFormPresenter) confirmField(form *forms.PerformRenewOrdersForm, formField *presenter.FormField) goc.HTML {
	field := this.Kit.Atoms.Fields.Field
	name := "form[confirm]"
	return field.Field("Confirm", this.Kit.Atoms.Inputs.BooleanInput.BooleanInput(name, form.Confirm))
}
func (this *PerformRenewOrdersFormPresenter) stepField(form *forms.PerformRenewOrdersForm, formField *presenter.FormField) goc.HTML {
	field := this.Kit.Atoms.Fields.Field
	name := "form[step]"
	return field.Field("Step", this.Kit.Atoms.Inputs.TextInput.TextInput(name, form.Step))
}
func (this *PerformRenewOrdersFormPresenter) step1Field(form *forms.PerformRenewOrdersForm, formField *presenter.FormField) goc.HTML {
	var set []goc.HTML
	for _, child := range formField.Children {
		set = append(set, this.FieldByKey(form, child))
	}
	return this.Kit.Component.Dcs("flex flex-col space-y-2", set...)
}
func (this *PerformRenewOrdersFormPresenter) step2Field(form *forms.PerformRenewOrdersForm, formField *presenter.FormField) goc.HTML {
	var set []goc.HTML
	for _, child := range formField.Children {
		set = append(set, this.FieldByKey(form, child))
	}
	return this.Kit.Component.Dcs("flex flex-col space-y-2", set...)
}
func (this *PerformRenewOrdersFormPresenter) step3Field(form *forms.PerformRenewOrdersForm, formField *presenter.FormField) goc.HTML {
	var set []goc.HTML
	for _, child := range formField.Children {
		set = append(set, this.FieldByKey(form, child))
	}
	return this.Kit.Component.Dcs("flex flex-col space-y-2", set...)
}
func (this *PerformRenewOrdersFormPresenter) groupedField(form *forms.PerformRenewOrdersForm, formField *presenter.FormField) goc.HTML {
	field := this.Kit.Atoms.Fields.Field
	name := "form[step1][grouped]"
	return field.Field("Grouped", this.Kit.Atoms.Inputs.BooleanInput.BooleanInput(name, form.Step1.Grouped))
}
func (this *PerformRenewOrdersFormPresenter) cropsField(form *forms.PerformRenewOrdersForm, formField *presenter.FormField) goc.HTML {
	var set []goc.HTML
	for _, child := range formField.Children {
		set = append(set, this.FieldByKey(form, child))
	}
	return this.Kit.Component.Dcs("flex flex-col space-y-2", set...)
}
func (this *PerformRenewOrdersFormPresenter) AddCropsFields(form *forms.PerformRenewOrdersForm, formFields []*presenter.FormField) []*presenter.FormField {
	templates := this.Presenter.FindTemplatesByKeyPrefix("step1.crops", formFields)
	for i := range form.Step1.Crops {
		for _, template := range templates {
			formField := this.Presenter.FormFieldFromTemplate(template, []int{i})
			formFields = append(formFields, formField)
		}
	}
	return formFields
}
func (this *PerformRenewOrdersFormPresenter) plantIdField(form *forms.PerformRenewOrdersForm, formField *presenter.FormField) goc.HTML {
	field := this.Kit.Atoms.Fields.Field
	i0 := formField.Indexes[0]
	name := this.Presenter.NameViaIndexes("form[step1][crops][%d][plant_id]", formField)
	return field.Field("Plant", this.Kit.Atoms.Inputs.TextInput.TextInput(name, form.Step1.Crops[i0].PlantId))
}
func (this *PerformRenewOrdersFormPresenter) quantityField(form *forms.PerformRenewOrdersForm, formField *presenter.FormField) goc.HTML {
	field := this.Kit.Atoms.Fields.Field
	i0 := formField.Indexes[0]
	name := this.Presenter.NameViaIndexes("form[step1][crops][%d][quantity]", formField)
	return field.Field("Quantity", this.Kit.Atoms.Inputs.IntegerInput.IntegerInput(name, form.Step1.Crops[i0].Quantity))
}
func (this *PerformRenewOrdersFormPresenter) addressField(form *forms.PerformRenewOrdersForm, formField *presenter.FormField) goc.HTML {
	field := this.Kit.Atoms.Fields.Field
	name := "form[step2][address]"
	return field.Field("Address", this.Kit.Atoms.Inputs.TextInput.TextInput(name, form.Step2.Address))
}
func (this *PerformRenewOrdersFormPresenter) countryField(form *forms.PerformRenewOrdersForm, formField *presenter.FormField) goc.HTML {
	field := this.Kit.Atoms.Fields.Field
	name := "form[step2][country]"
	return field.Field("Country", this.Kit.Atoms.Inputs.TextInput.TextInput(name, form.Step2.Country))
}
func (this *PerformRenewOrdersFormPresenter) emailsField(form *forms.PerformRenewOrdersForm, formField *presenter.FormField) goc.HTML {
	var set []goc.HTML
	for _, child := range formField.Children {
		set = append(set, this.FieldByKey(form, child))
	}
	return this.Kit.Component.Dcs("flex flex-col space-y-2", set...)
}
func (this *PerformRenewOrdersFormPresenter) AddEmailsFields(form *forms.PerformRenewOrdersForm, formFields []*presenter.FormField) []*presenter.FormField {
	templates := this.Presenter.FindTemplatesByKeyPrefix("step3.emails", formFields)
	for i := range form.Step3.Emails {
		for _, template := range templates {
			formField := this.Presenter.FormFieldFromTemplate(template, []int{i})
			formFields = append(formFields, formField)
		}
	}
	return formFields
}
func (this *PerformRenewOrdersFormPresenter) emailField(form *forms.PerformRenewOrdersForm, formField *presenter.FormField) goc.HTML {
	field := this.Kit.Atoms.Fields.Field
	i0 := formField.Indexes[0]
	name := this.Presenter.NameViaIndexes("form[step3][emails][%d][email]", formField)
	return field.Field("Email", this.Kit.Atoms.Inputs.TextInput.TextInput(name, form.Step3.Emails[i0].Email))
}
func (this *PerformRenewOrdersFormPresenter) GetFields() []*presenter.FormField {
	var formFields []*presenter.FormField
	formFields = append(formFields, &presenter.FormField{
		Key:   "confirm",
		Label: "Confirm",
	})
	formFields = append(formFields, &presenter.FormField{
		Key:   "step",
		Label: "Step",
	})
	formFields = append(formFields, &presenter.FormField{
		Key:   "step1",
		Label: "Step1",
	})
	formFields = append(formFields, &presenter.FormField{
		Key:   "step2",
		Label: "Step2",
	})
	formFields = append(formFields, &presenter.FormField{
		Key:   "step3",
		Label: "Step3",
	})
	formFields = append(formFields, &presenter.FormField{
		Key:   "step1.grouped",
		Label: "Grouped",
	})
	formFields = append(formFields, &presenter.FormField{
		Key:   "step1.crops",
		Label: "Crops",
	})
	formFields = append(formFields, &presenter.FormField{
		Key:      "step1.crops.plant_id",
		Label:    "Plant",
		Template: true,
	})
	formFields = append(formFields, &presenter.FormField{
		Key:      "step1.crops.quantity",
		Label:    "Quantity",
		Template: true,
	})
	formFields = append(formFields, &presenter.FormField{
		Key:   "step2.address",
		Label: "Address",
	})
	formFields = append(formFields, &presenter.FormField{
		Key:   "step2.country",
		Label: "Country",
	})
	formFields = append(formFields, &presenter.FormField{
		Key:   "step3.emails",
		Label: "Emails",
	})
	formFields = append(formFields, &presenter.FormField{
		Key:      "step3.emails.email",
		Label:    "Email",
		Template: true,
	})
	return formFields
}
func (this *PerformRenewOrdersFormPresenter) FieldByKey(form *forms.PerformRenewOrdersForm, formField *presenter.FormField) goc.HTML {
	switch formField.Key {
	case "confirm":
		return this.confirmField(form, formField)
	case "step":
		return this.stepField(form, formField)
	case "step1":
		return this.step1Field(form, formField)
	case "step2":
		return this.step2Field(form, formField)
	case "step3":
		return this.step3Field(form, formField)
	case "step1.grouped":
		return this.groupedField(form, formField)
	case "step1.crops":
		return this.cropsField(form, formField)
	case "step1.crops.plant_id":
		return this.plantIdField(form, formField)
	case "step1.crops.quantity":
		return this.quantityField(form, formField)
	case "step2.address":
		return this.addressField(form, formField)
	case "step2.country":
		return this.countryField(form, formField)
	case "step3.emails":
		return this.emailsField(form, formField)
	case "step3.emails.email":
		return this.emailField(form, formField)
	}
	panic(erro.N("Invalid form field").KV("key", formField.Key))
}
func (this *PerformRenewOrdersFormPresenter) Setup(form *forms.PerformRenewOrdersForm) []*presenter.FormField {
	fields := this.GetFields()
	fields = this.AddCropsFields(form, fields)
	fields = this.AddEmailsFields(form, fields)
	fields = this.Presenter.TrimTemplates(fields)
	fields = this.Presenter.TransformIntoTree(fields)
	return fields
}
