package form_presenters

// |@@| C

import (
	"gardening/src/dat/forms"
	"gardening/src/lib/error"
	"gardening/src/lib/kit"
	"gardening/src/lib/presenter"
	"gitlab.com/ccyrillee/kitcla/goc"
	u "gitlab.com/ccyrillee/kitcla/goc_utils"
)

type UpdateGardenFormPresenter struct {
	Kit       *kit.Kit
	Presenter *presenter.Presenter
}

func (this *UpdateGardenFormPresenter) idField(form *forms.UpdateGardenForm, formField *presenter.FormField) goc.HTML {
	field := this.Kit.Atoms.Fields.Field
	name := "form[id]"
	return field.HiddenField("Id", this.Kit.Atoms.Inputs.HiddenInput.HiddenInput(name, form.Id))
}
func (this *UpdateGardenFormPresenter) nameField(form *forms.UpdateGardenForm, formField *presenter.FormField) goc.HTML {
	field := this.Kit.Atoms.Fields.Field
	name := "form[name]"
	return field.Field("Name", this.Kit.Atoms.Inputs.TextInput.TextInput(name, form.Name))
}
func (this *UpdateGardenFormPresenter) pictureField(form *forms.UpdateGardenForm, formField *presenter.FormField) goc.HTML {
	field := this.Kit.Atoms.Fields.Field
	name := "form[picture]"
	v1 := this.Kit.Atoms.Inputs.TextInput.TextInput(name, form.Picture)
	v2 := this.Kit.Atoms.Inputs.FileInput.FileInput("picture")
	return field.Field("Picture", u.Ds(v1, v2))
}
func (this *UpdateGardenFormPresenter) GetFields() []*presenter.FormField {
	var formFields []*presenter.FormField
	formFields = append(formFields, &presenter.FormField{
		Key:   "id",
		Label: "Id",
	})
	formFields = append(formFields, &presenter.FormField{
		Key:   "name",
		Label: "Name",
	})
	formFields = append(formFields, &presenter.FormField{
		Key:   "picture",
		Label: "Picture",
	})
	return formFields
}
func (this *UpdateGardenFormPresenter) FieldByKey(form *forms.UpdateGardenForm, formField *presenter.FormField) goc.HTML {
	switch formField.Key {
	case "id":
		return this.idField(form, formField)
	case "name":
		return this.nameField(form, formField)
	case "picture":
		return this.pictureField(form, formField)
	}
	panic(erro.N("Invalid form field").KV("key", formField.Key))
}
func (this *UpdateGardenFormPresenter) Setup(form *forms.UpdateGardenForm) []*presenter.FormField {
	fields := this.GetFields()
	return fields
}
