package form_presenters

// |@@| C

import (
	"gardening/src/dat/forms"
	"gardening/src/lib/error"
	"gardening/src/lib/kit"
	"gardening/src/lib/presenter"
	"gitlab.com/ccyrillee/kitcla/goc"
)

type UpdatePlantFormPresenter struct {
	Kit       *kit.Kit
	Presenter *presenter.Presenter
}

func (this *UpdatePlantFormPresenter) idField(form *forms.UpdatePlantForm, formField *presenter.FormField) goc.HTML {
	field := this.Kit.Atoms.Fields.Field
	name := "form[id]"
	return field.HiddenField("Id", this.Kit.Atoms.Inputs.HiddenInput.HiddenInput(name, form.Id))
}
func (this *UpdatePlantFormPresenter) dataField(form *forms.UpdatePlantForm, formField *presenter.FormField) goc.HTML {
	field := this.Kit.Atoms.Fields.Field
	name := "form[data]"
	return field.Field("Data", this.Kit.Atoms.Inputs.JsonInput.JsonInput(name, form.Data))
}
func (this *UpdatePlantFormPresenter) descriptionField(form *forms.UpdatePlantForm, formField *presenter.FormField) goc.HTML {
	field := this.Kit.Atoms.Fields.Field
	name := "form[description]"
	return field.Field("Description", this.Kit.Atoms.Inputs.TextInput.TextInput(name, form.Description))
}
func (this *UpdatePlantFormPresenter) expositionField(form *forms.UpdatePlantForm, formField *presenter.FormField) goc.HTML {
	field := this.Kit.Atoms.Fields.Field
	name := "form[exposition]"
	return field.Field("Exposition", this.Kit.Atoms.Inputs.TextInput.TextInput(name, form.Exposition))
}
func (this *UpdatePlantFormPresenter) harvestedField(form *forms.UpdatePlantForm, formField *presenter.FormField) goc.HTML {
	field := this.Kit.Atoms.Fields.Field
	name := "form[harvested]"
	return field.Field("Harvested", this.Kit.Atoms.Inputs.DecimalInput.DecimalInput(name, form.Harvested))
}
func (this *UpdatePlantFormPresenter) nameField(form *forms.UpdatePlantForm, formField *presenter.FormField) goc.HTML {
	field := this.Kit.Atoms.Fields.Field
	name := "form[name]"
	return field.Field("Name", this.Kit.Atoms.Inputs.TextInput.TextInput(name, form.Name))
}
func (this *UpdatePlantFormPresenter) perennialField(form *forms.UpdatePlantForm, formField *presenter.FormField) goc.HTML {
	field := this.Kit.Atoms.Fields.Field
	name := "form[perennial]"
	return field.Field("Perennial", this.Kit.Atoms.Inputs.BooleanInput.BooleanInput(name, form.Perennial))
}
func (this *UpdatePlantFormPresenter) referenceField(form *forms.UpdatePlantForm, formField *presenter.FormField) goc.HTML {
	field := this.Kit.Atoms.Fields.Field
	name := "form[reference]"
	return field.Field("Reference", this.Kit.Atoms.Inputs.TextInput.TextInput(name, form.Reference))
}
func (this *UpdatePlantFormPresenter) sizeField(form *forms.UpdatePlantForm, formField *presenter.FormField) goc.HTML {
	field := this.Kit.Atoms.Fields.Field
	name := "form[size]"
	return field.Field("Size", this.Kit.Atoms.Inputs.IntegerInput.IntegerInput(name, form.Size))
}
func (this *UpdatePlantFormPresenter) GetFields() []*presenter.FormField {
	var formFields []*presenter.FormField
	formFields = append(formFields, &presenter.FormField{
		Key:   "id",
		Label: "Id",
	})
	formFields = append(formFields, &presenter.FormField{
		Key:   "data",
		Label: "Data",
	})
	formFields = append(formFields, &presenter.FormField{
		Key:   "description",
		Label: "Description",
	})
	formFields = append(formFields, &presenter.FormField{
		Key:   "exposition",
		Label: "Exposition",
	})
	formFields = append(formFields, &presenter.FormField{
		Key:   "harvested",
		Label: "Harvested",
	})
	formFields = append(formFields, &presenter.FormField{
		Key:   "name",
		Label: "Name",
	})
	formFields = append(formFields, &presenter.FormField{
		Key:   "perennial",
		Label: "Perennial",
	})
	formFields = append(formFields, &presenter.FormField{
		Key:   "reference",
		Label: "Reference",
	})
	formFields = append(formFields, &presenter.FormField{
		Key:   "size",
		Label: "Size",
	})
	return formFields
}
func (this *UpdatePlantFormPresenter) FieldByKey(form *forms.UpdatePlantForm, formField *presenter.FormField) goc.HTML {
	switch formField.Key {
	case "id":
		return this.idField(form, formField)
	case "data":
		return this.dataField(form, formField)
	case "description":
		return this.descriptionField(form, formField)
	case "exposition":
		return this.expositionField(form, formField)
	case "harvested":
		return this.harvestedField(form, formField)
	case "name":
		return this.nameField(form, formField)
	case "perennial":
		return this.perennialField(form, formField)
	case "reference":
		return this.referenceField(form, formField)
	case "size":
		return this.sizeField(form, formField)
	}
	panic(erro.N("Invalid form field").KV("key", formField.Key))
}
func (this *UpdatePlantFormPresenter) Setup(form *forms.UpdatePlantForm) []*presenter.FormField {
	fields := this.GetFields()
	return fields
}
