package form_presenters

// |@@| C

import (
	"gardening/src/dat/forms"
	"gardening/src/lib/error"
	"gardening/src/lib/kit"
	"gardening/src/lib/presenter"
	"gitlab.com/ccyrillee/kitcla/goc"
)

type UpdatePlantTaskFormPresenter struct {
	Kit       *kit.Kit
	Presenter *presenter.Presenter
}

func (this *UpdatePlantTaskFormPresenter) idField(form *forms.UpdatePlantTaskForm, formField *presenter.FormField) goc.HTML {
	field := this.Kit.Atoms.Fields.Field
	name := "form[id]"
	return field.HiddenField("Id", this.Kit.Atoms.Inputs.HiddenInput.HiddenInput(name, form.Id))
}
func (this *UpdatePlantTaskFormPresenter) descriptionField(form *forms.UpdatePlantTaskForm, formField *presenter.FormField) goc.HTML {
	field := this.Kit.Atoms.Fields.Field
	name := "form[description]"
	return field.Field("Description", this.Kit.Atoms.Inputs.TextInput.TextInput(name, form.Description))
}
func (this *UpdatePlantTaskFormPresenter) nameField(form *forms.UpdatePlantTaskForm, formField *presenter.FormField) goc.HTML {
	field := this.Kit.Atoms.Fields.Field
	name := "form[name]"
	return field.Field("Name", this.Kit.Atoms.Inputs.TextInput.TextInput(name, form.Name))
}
func (this *UpdatePlantTaskFormPresenter) startDateField(form *forms.UpdatePlantTaskForm, formField *presenter.FormField) goc.HTML {
	field := this.Kit.Atoms.Fields.Field
	name := "form[start_date]"
	return field.Field("Start Date", this.Kit.Atoms.Inputs.DatetimeInput.DatetimeInput(name, form.StartDate.Format("2006-01-02T15:04:05")))
}
func (this *UpdatePlantTaskFormPresenter) plantIdField(form *forms.UpdatePlantTaskForm, formField *presenter.FormField) goc.HTML {
	field := this.Kit.Atoms.Fields.Field
	name := "form[plant_id]"
	return field.Field("Plant", this.Kit.Atoms.Inputs.AdvancedSelectInput.AdvancedSelectInput2(name, form.PlantId, "plants", nil))
}
func (this *UpdatePlantTaskFormPresenter) GetFields() []*presenter.FormField {
	var formFields []*presenter.FormField
	formFields = append(formFields, &presenter.FormField{
		Key:   "id",
		Label: "Id",
	})
	formFields = append(formFields, &presenter.FormField{
		Key:   "description",
		Label: "Description",
	})
	formFields = append(formFields, &presenter.FormField{
		Key:   "name",
		Label: "Name",
	})
	formFields = append(formFields, &presenter.FormField{
		Key:    "start_date",
		Label:  "Start Date",
		Hidden: true,
	})
	formFields = append(formFields, &presenter.FormField{
		Key:   "plant_id",
		Label: "Plant",
	})
	return formFields
}
func (this *UpdatePlantTaskFormPresenter) FieldByKey(form *forms.UpdatePlantTaskForm, formField *presenter.FormField) goc.HTML {
	switch formField.Key {
	case "id":
		return this.idField(form, formField)
	case "description":
		return this.descriptionField(form, formField)
	case "name":
		return this.nameField(form, formField)
	case "start_date":
		return this.startDateField(form, formField)
	case "plant_id":
		return this.plantIdField(form, formField)
	}
	panic(erro.N("Invalid form field").KV("key", formField.Key))
}
func (this *UpdatePlantTaskFormPresenter) Setup(form *forms.UpdatePlantTaskForm) []*presenter.FormField {
	fields := this.GetFields()
	return fields
}
