package form_presenters

// |@@| C

import (
	"gardening/src/dat/forms"
	"gardening/src/lib/error"
	"gardening/src/lib/kit"
	"gardening/src/lib/presenter"
	"gitlab.com/ccyrillee/kitcla/goc"
)

type UpdatePlantationFormPresenter struct {
	Kit       *kit.Kit
	Presenter *presenter.Presenter
}

func (this *UpdatePlantationFormPresenter) idField(form *forms.UpdatePlantationForm, formField *presenter.FormField) goc.HTML {
	field := this.Kit.Atoms.Fields.Field
	name := "form[id]"
	return field.HiddenField("Id", this.Kit.Atoms.Inputs.HiddenInput.HiddenInput(name, form.Id))
}
func (this *UpdatePlantationFormPresenter) nameField(form *forms.UpdatePlantationForm, formField *presenter.FormField) goc.HTML {
	field := this.Kit.Atoms.Fields.Field
	name := "form[name]"
	return field.Field("Name", this.Kit.Atoms.Inputs.TextInput.TextInput(name, form.Name))
}
func (this *UpdatePlantationFormPresenter) plantedAtField(form *forms.UpdatePlantationForm, formField *presenter.FormField) goc.HTML {
	field := this.Kit.Atoms.Fields.Field
	name := "form[planted_at]"
	return field.Field("Planted At", this.Kit.Atoms.Inputs.DatetimeInput.DatetimeInput(name, form.PlantedAt.Format("2006-01-02T15:04:05")))
}
func (this *UpdatePlantationFormPresenter) plantIdField(form *forms.UpdatePlantationForm, formField *presenter.FormField) goc.HTML {
	field := this.Kit.Atoms.Fields.Field
	name := "form[plant_id]"
	return field.Field("Plant", this.Kit.Atoms.Inputs.AdvancedSelectInput.AdvancedSelectInput2(name, form.PlantId, "plants", nil))
}
func (this *UpdatePlantationFormPresenter) gardenIdField(form *forms.UpdatePlantationForm, formField *presenter.FormField) goc.HTML {
	field := this.Kit.Atoms.Fields.Field
	name := "form[garden_id]"
	return field.Field("Garden", this.Kit.Atoms.Inputs.AdvancedSelectInput.AdvancedSelectInput2(name, form.GardenId, "gardens", nil))
}
func (this *UpdatePlantationFormPresenter) GetFields() []*presenter.FormField {
	var formFields []*presenter.FormField
	formFields = append(formFields, &presenter.FormField{
		Key:   "id",
		Label: "Id",
	})
	formFields = append(formFields, &presenter.FormField{
		Key:   "name",
		Label: "Name",
	})
	formFields = append(formFields, &presenter.FormField{
		Key:   "planted_at",
		Label: "Planted At",
	})
	formFields = append(formFields, &presenter.FormField{
		Key:   "plant_id",
		Label: "Plant",
	})
	formFields = append(formFields, &presenter.FormField{
		Key:   "garden_id",
		Label: "Garden",
	})
	return formFields
}
func (this *UpdatePlantationFormPresenter) FieldByKey(form *forms.UpdatePlantationForm, formField *presenter.FormField) goc.HTML {
	switch formField.Key {
	case "id":
		return this.idField(form, formField)
	case "name":
		return this.nameField(form, formField)
	case "planted_at":
		return this.plantedAtField(form, formField)
	case "plant_id":
		return this.plantIdField(form, formField)
	case "garden_id":
		return this.gardenIdField(form, formField)
	}
	panic(erro.N("Invalid form field").KV("key", formField.Key))
}
func (this *UpdatePlantationFormPresenter) Setup(form *forms.UpdatePlantationForm) []*presenter.FormField {
	fields := this.GetFields()
	return fields
}
