package form_presenters

// |@@| C

import (
	"gardening/src/dat/forms"
	"gardening/src/lib/error"
	"gardening/src/lib/kit"
	"gardening/src/lib/presenter"
	"gitlab.com/ccyrillee/kitcla/goc"
)

type UpdateUserFormPresenter struct {
	Kit       *kit.Kit
	Presenter *presenter.Presenter
}

func (this *UpdateUserFormPresenter) idField(form *forms.UpdateUserForm, formField *presenter.FormField) goc.HTML {
	field := this.Kit.Atoms.Fields.Field
	name := "form[id]"
	return field.HiddenField("Id", this.Kit.Atoms.Inputs.HiddenInput.HiddenInput(name, form.Id))
}
func (this *UpdateUserFormPresenter) nameField(form *forms.UpdateUserForm, formField *presenter.FormField) goc.HTML {
	field := this.Kit.Atoms.Fields.Field
	name := "form[name]"
	return field.Field("Name", this.Kit.Atoms.Inputs.TextInput.TextInput(name, form.Name))
}
func (this *UpdateUserFormPresenter) GetFields() []*presenter.FormField {
	var formFields []*presenter.FormField
	formFields = append(formFields, &presenter.FormField{
		Key:   "id",
		Label: "Id",
	})
	formFields = append(formFields, &presenter.FormField{
		Key:   "name",
		Label: "Name",
	})
	return formFields
}
func (this *UpdateUserFormPresenter) FieldByKey(form *forms.UpdateUserForm, formField *presenter.FormField) goc.HTML {
	switch formField.Key {
	case "id":
		return this.idField(form, formField)
	case "name":
		return this.nameField(form, formField)
	}
	panic(erro.N("Invalid form field").KV("key", formField.Key))
}
func (this *UpdateUserFormPresenter) Setup(form *forms.UpdateUserForm) []*presenter.FormField {
	fields := this.GetFields()
	return fields
}
