package form_validators

// |@@| C

import (
	"context"
	"gardening/src/dat/forms"
	formLib "gardening/src/lib/form"
	"gardening/src/lib/validator"
)

type CreatePlantationFormValidator struct {
	Validator *validator.Validator
}

func (this *CreatePlantationFormValidator) Validate(ctx context.Context, form *forms.CreatePlantationForm) (*formLib.FormBag, error) {
	bag := this.Validator.MakeFormBag()
	if !this.Validator.IsValid(bag) {
		return bag, this.Validator.NewInvalidFormError(ctx, bag)
	}
	return bag, nil
}
