package form_validators

// |@@| C

import (
	"context"
	"gardening/src/dat/forms"
	formLib "gardening/src/lib/form"
	"gardening/src/lib/validator"
)

type PerformEventsFormValidator struct {
	Validator *validator.Validator
}

func (this *PerformEventsFormValidator) Validate(ctx context.Context, form *forms.PerformEventsForm) (*formLib.FormBag, error) {
	bag := this.Validator.MakeFormBag()
	if !this.Validator.IsValid(bag) {
		return bag, this.Validator.NewInvalidFormError(ctx, bag)
	}
	return bag, nil
}
