package form_validators

// |@@| C

import (
	"context"
	"gardening/src/dat/forms"
	formLib "gardening/src/lib/form"
	"gardening/src/lib/validator"
)

type PerformRenewOrdersFormValidator struct {
	Validator *validator.Validator
}

func (this *PerformRenewOrdersFormValidator) Validate(ctx context.Context, form *forms.PerformRenewOrdersForm) (*formLib.FormBag, error) {
	bag := this.Validator.MakeFormBag()
	this.validateStep(form, bag)
	this.validateStep1(form, bag)
	this.validateStep2(form, bag)
	this.validateStep3(form, bag)
	if !this.Validator.IsValid(bag) {
		return bag, this.Validator.NewInvalidFormError(ctx, bag)
	}
	return bag, nil
}
func (this *PerformRenewOrdersFormValidator) validateStep(form *forms.PerformRenewOrdersForm, bag *formLib.FormBag) {
	this.Validator.ValidateStringRequired(bag, form.Step, "Step", nil)
}
func (this *PerformRenewOrdersFormValidator) validateStep1(form *forms.PerformRenewOrdersForm, bag *formLib.FormBag) {
	this.validateCrops(form, bag)
}
func (this *PerformRenewOrdersFormValidator) validateCrops(form *forms.PerformRenewOrdersForm, bag *formLib.FormBag) {
	this.validatePlantId(form, bag)
}
func (this *PerformRenewOrdersFormValidator) validatePlantId(form *forms.PerformRenewOrdersForm, bag *formLib.FormBag) {
	this.Validator.ValidateStringRequired(bag, form.Step1.Crops[0].PlantId, "PlantId", nil)
}
func (this *PerformRenewOrdersFormValidator) validateStep2(form *forms.PerformRenewOrdersForm, bag *formLib.FormBag) {
	this.validateAddress(form, bag)
	this.validateCountry(form, bag)
}
func (this *PerformRenewOrdersFormValidator) validateAddress(form *forms.PerformRenewOrdersForm, bag *formLib.FormBag) {
	this.Validator.ValidateStringRequired(bag, form.Step2.Address, "Address", nil)
}
func (this *PerformRenewOrdersFormValidator) validateCountry(form *forms.PerformRenewOrdersForm, bag *formLib.FormBag) {
	this.Validator.ValidateStringRequired(bag, form.Step2.Country, "Country", nil)
}
func (this *PerformRenewOrdersFormValidator) validateStep3(form *forms.PerformRenewOrdersForm, bag *formLib.FormBag) {
	this.validateEmails(form, bag)
}
func (this *PerformRenewOrdersFormValidator) validateEmails(form *forms.PerformRenewOrdersForm, bag *formLib.FormBag) {
	this.validateEmail(form, bag)
}
func (this *PerformRenewOrdersFormValidator) validateEmail(form *forms.PerformRenewOrdersForm, bag *formLib.FormBag) {
	this.Validator.ValidateStringRequired(bag, form.Step3.Emails[0].Email, "Email", nil)
}
