package handlers

// |@@| C

import (
	"context"
	"gardening/src/lib"
	"gardening/src/lib/handler"
	"gardening/src/mdl"
	"gardening/src/srv/tables"
)

type EventHandler struct {
	EventTable *tables.EventTable
	Handler    *handler.Handler
}

func (this *EventHandler) Create(ctx context.Context, entity *mdl.Event, mod *handler.HandlerMod) (*mdl.Event, error) {
	mod = this.modDefaulting(mod)
	this.setColumns(mod, entity)
	this.setUtilities(mod, entity, "create")
	mod.Table = this.EventTable.TableName()

	id, _, err := this.Handler.Create(ctx, mod)
	if err != nil {
		return nil, err
	}
	entity.Id = id
	return entity, nil
}
func (this *EventHandler) MustCreate(ctx context.Context, entity *mdl.Event, mod *handler.HandlerMod) *mdl.Event {
	p1, err := this.Create(ctx, entity, mod)
	lib.Poe(err)
	return p1
}
func (this *EventHandler) Update(ctx context.Context, entity *mdl.Event, mod *handler.HandlerMod) (*mdl.Event, error) {
	mod = this.modDefaulting(mod)
	this.setColumns(mod, entity)
	this.setUtilities(mod, entity, "update")
	mod.Table = this.EventTable.TableName()
	mod.Id = entity.Id

	_, err := this.Handler.Update(ctx, mod)
	if err != nil {
		return nil, err
	}
	return entity, nil
}
func (this *EventHandler) MustUpdate(ctx context.Context, entity *mdl.Event, mod *handler.HandlerMod) *mdl.Event {
	p1, err := this.Update(ctx, entity, mod)
	lib.Poe(err)
	return p1
}
func (this *EventHandler) UpdateFields(ctx context.Context, entity *mdl.Event, fields []string, mod *handler.HandlerMod) (*mdl.Event, error) {
	mod = this.modDefaulting(mod)
	mod.Fields = fields
	return this.Update(ctx, entity, mod)
}
func (this *EventHandler) MustUpdateFields(ctx context.Context, entity *mdl.Event, fields []string, mod *handler.HandlerMod) *mdl.Event {
	p1, err := this.UpdateFields(ctx, entity, fields, mod)
	lib.Poe(err)
	return p1
}
func (this *EventHandler) Delete(ctx context.Context, event *mdl.Event, mod *handler.HandlerMod) error {
	mod = this.modDefaulting(mod)
	mod.Table = this.EventTable.TableName()
	mod.Id = event.Id
	_, err := this.Handler.Delete(ctx, mod)
	if err != nil {
		return err
	}
	return nil
}
func (this *EventHandler) MustDelete(ctx context.Context, event *mdl.Event, mod *handler.HandlerMod) {
	err := this.Delete(ctx, event, mod)
	lib.Poe(err)
	return
}
func (this *EventHandler) modDefaulting(mod *handler.HandlerMod) *handler.HandlerMod {
	if mod == nil {
		return &handler.HandlerMod{}
	}
	return mod
}
func (this *EventHandler) setColumns(mod *handler.HandlerMod, entity *mdl.Event) {
	table := this.EventTable
	fields := mod.Fields
	if len(fields) == 0 {
		fields = table.Fields()
	}
	indexes := this.Handler.IndexesFromFields(fields, table.Fields())
	indexes = this.Handler.ExcludeUtilitiesIndexes(indexes, table.Fields())
	mod.Columns = this.Handler.StringSubsetFromIndexes(indexes, table.Columns())
	mod.Values = this.Handler.InterfaceSubsetFromIndexes(indexes, table.EntityToValues(entity))
}
func (this *EventHandler) setUtilities(mod *handler.HandlerMod, entity *mdl.Event, action string) {
	if action == "create" {
		this.Handler.AppendColumnValueAtNow("created_at", mod)
	}
	if action == "update" || action == "create" {
		this.Handler.AppendColumnValueAtNow("updated_at", mod)
	}
}
