package handlers

// |@@| C

import (
	"context"
	"gardening/src/lib"
	"gardening/src/lib/handler"
	"gardening/src/mdl"
	"gardening/src/srv/tables"
)

type GardenHandler struct {
	GardenTable *tables.GardenTable
	Handler     *handler.Handler
}

func (this *GardenHandler) Create(ctx context.Context, entity *mdl.Garden, mod *handler.HandlerMod) (*mdl.Garden, error) {
	mod = this.modDefaulting(mod)
	this.setColumns(mod, entity)
	this.setUtilities(mod, entity, "create")
	mod.Table = this.GardenTable.TableName()

	id, _, err := this.Handler.Create(ctx, mod)
	if err != nil {
		return nil, err
	}
	entity.Id = id
	return entity, nil
}
func (this *GardenHandler) MustCreate(ctx context.Context, entity *mdl.Garden, mod *handler.HandlerMod) *mdl.Garden {
	p1, err := this.Create(ctx, entity, mod)
	lib.Poe(err)
	return p1
}
func (this *GardenHandler) Update(ctx context.Context, entity *mdl.Garden, mod *handler.HandlerMod) (*mdl.Garden, error) {
	mod = this.modDefaulting(mod)
	this.setColumns(mod, entity)
	this.setUtilities(mod, entity, "update")
	mod.Table = this.GardenTable.TableName()
	mod.Id = entity.Id

	_, err := this.Handler.Update(ctx, mod)
	if err != nil {
		return nil, err
	}
	return entity, nil
}
func (this *GardenHandler) MustUpdate(ctx context.Context, entity *mdl.Garden, mod *handler.HandlerMod) *mdl.Garden {
	p1, err := this.Update(ctx, entity, mod)
	lib.Poe(err)
	return p1
}
func (this *GardenHandler) UpdateFields(ctx context.Context, entity *mdl.Garden, fields []string, mod *handler.HandlerMod) (*mdl.Garden, error) {
	mod = this.modDefaulting(mod)
	mod.Fields = fields
	return this.Update(ctx, entity, mod)
}
func (this *GardenHandler) MustUpdateFields(ctx context.Context, entity *mdl.Garden, fields []string, mod *handler.HandlerMod) *mdl.Garden {
	p1, err := this.UpdateFields(ctx, entity, fields, mod)
	lib.Poe(err)
	return p1
}
func (this *GardenHandler) Delete(ctx context.Context, garden *mdl.Garden, mod *handler.HandlerMod) error {
	mod = this.modDefaulting(mod)
	mod.Table = this.GardenTable.TableName()
	mod.Id = garden.Id
	_, err := this.Handler.Delete(ctx, mod)
	if err != nil {
		return err
	}
	return nil
}
func (this *GardenHandler) MustDelete(ctx context.Context, garden *mdl.Garden, mod *handler.HandlerMod) {
	err := this.Delete(ctx, garden, mod)
	lib.Poe(err)
	return
}
func (this *GardenHandler) modDefaulting(mod *handler.HandlerMod) *handler.HandlerMod {
	if mod == nil {
		return &handler.HandlerMod{}
	}
	return mod
}
func (this *GardenHandler) setColumns(mod *handler.HandlerMod, entity *mdl.Garden) {
	table := this.GardenTable
	fields := mod.Fields
	if len(fields) == 0 {
		fields = table.Fields()
	}
	indexes := this.Handler.IndexesFromFields(fields, table.Fields())
	indexes = this.Handler.ExcludeUtilitiesIndexes(indexes, table.Fields())
	mod.Columns = this.Handler.StringSubsetFromIndexes(indexes, table.Columns())
	mod.Values = this.Handler.InterfaceSubsetFromIndexes(indexes, table.EntityToValues(entity))
}
func (this *GardenHandler) setUtilities(mod *handler.HandlerMod, entity *mdl.Garden, action string) {
	if action == "create" {
		this.Handler.AppendColumnValueAtNow("created_at", mod)
	}
	if action == "update" || action == "create" {
		this.Handler.AppendColumnValueAtNow("updated_at", mod)
	}
}
