package handlers

// |@@| C

import (
	"context"
	"gardening/src/lib"
	"gardening/src/lib/handler"
	"gardening/src/mdl"
	"gardening/src/srv/tables"
)

type GardenTaskHandler struct {
	GardenTaskTable *tables.GardenTaskTable
	Handler         *handler.Handler
}

func (this *GardenTaskHandler) Create(ctx context.Context, entity *mdl.GardenTask, mod *handler.HandlerMod) (*mdl.GardenTask, error) {
	mod = this.modDefaulting(mod)
	this.setColumns(mod, entity)
	this.setUtilities(mod, entity, "create")
	mod.Table = this.GardenTaskTable.TableName()

	id, _, err := this.Handler.Create(ctx, mod)
	if err != nil {
		return nil, err
	}
	entity.Id = id
	return entity, nil
}
func (this *GardenTaskHandler) MustCreate(ctx context.Context, entity *mdl.GardenTask, mod *handler.HandlerMod) *mdl.GardenTask {
	p1, err := this.Create(ctx, entity, mod)
	lib.Poe(err)
	return p1
}
func (this *GardenTaskHandler) Update(ctx context.Context, entity *mdl.GardenTask, mod *handler.HandlerMod) (*mdl.GardenTask, error) {
	mod = this.modDefaulting(mod)
	this.setColumns(mod, entity)
	this.setUtilities(mod, entity, "update")
	mod.Table = this.GardenTaskTable.TableName()
	mod.Id = entity.Id

	_, err := this.Handler.Update(ctx, mod)
	if err != nil {
		return nil, err
	}
	return entity, nil
}
func (this *GardenTaskHandler) MustUpdate(ctx context.Context, entity *mdl.GardenTask, mod *handler.HandlerMod) *mdl.GardenTask {
	p1, err := this.Update(ctx, entity, mod)
	lib.Poe(err)
	return p1
}
func (this *GardenTaskHandler) UpdateFields(ctx context.Context, entity *mdl.GardenTask, fields []string, mod *handler.HandlerMod) (*mdl.GardenTask, error) {
	mod = this.modDefaulting(mod)
	mod.Fields = fields
	return this.Update(ctx, entity, mod)
}
func (this *GardenTaskHandler) MustUpdateFields(ctx context.Context, entity *mdl.GardenTask, fields []string, mod *handler.HandlerMod) *mdl.GardenTask {
	p1, err := this.UpdateFields(ctx, entity, fields, mod)
	lib.Poe(err)
	return p1
}
func (this *GardenTaskHandler) Delete(ctx context.Context, gardenTask *mdl.GardenTask, mod *handler.HandlerMod) error {
	mod = this.modDefaulting(mod)
	mod.Table = this.GardenTaskTable.TableName()
	mod.Id = gardenTask.Id
	_, err := this.Handler.Delete(ctx, mod)
	if err != nil {
		return err
	}
	return nil
}
func (this *GardenTaskHandler) MustDelete(ctx context.Context, gardenTask *mdl.GardenTask, mod *handler.HandlerMod) {
	err := this.Delete(ctx, gardenTask, mod)
	lib.Poe(err)
	return
}
func (this *GardenTaskHandler) modDefaulting(mod *handler.HandlerMod) *handler.HandlerMod {
	if mod == nil {
		return &handler.HandlerMod{}
	}
	return mod
}
func (this *GardenTaskHandler) setColumns(mod *handler.HandlerMod, entity *mdl.GardenTask) {
	table := this.GardenTaskTable
	fields := mod.Fields
	if len(fields) == 0 {
		fields = table.Fields()
	}
	indexes := this.Handler.IndexesFromFields(fields, table.Fields())
	indexes = this.Handler.ExcludeUtilitiesIndexes(indexes, table.Fields())
	mod.Columns = this.Handler.StringSubsetFromIndexes(indexes, table.Columns())
	mod.Values = this.Handler.InterfaceSubsetFromIndexes(indexes, table.EntityToValues(entity))
}
func (this *GardenTaskHandler) setUtilities(mod *handler.HandlerMod, entity *mdl.GardenTask, action string) {
	if action == "create" {
		this.Handler.AppendColumnValueAtNow("created_at", mod)
	}
	if action == "update" || action == "create" {
		this.Handler.AppendColumnValueAtNow("updated_at", mod)
	}
}
